<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/common.xsl"/>	

	<xsl:template name="AudioVideo">
		<xsl:param name="masterSourceRef"/>
		<xsl:param name="previewOrTitle"/>
		<xsl:param name="assetType"/>
		<xsl:call-template name="ContentAsset">
			<xsl:with-param name="masterSourceRef" select="$masterSourceRef"/>
			<xsl:with-param name="assetType" select="$assetType"/>
		</xsl:call-template>
			
		<xsl:for-each select="Fields/Video/AudioInfos/AudioInfo">
			<content:AudioType>
				<xsl:value-of select="Value"/>
			</content:AudioType>
		</xsl:for-each>
		<xsl:if test="Fields/Video/ScreenFormat">
			<content:ScreenFormat>
				<xsl:value-of select="Fields/Video/ScreenFormat"/>
			</content:ScreenFormat>
		</xsl:if>
		<xsl:if test="Fields/Content/Resolution">
			<content:Resolution><xsl:value-of select="Fields/Content/Resolution"/></content:Resolution>
		</xsl:if>
		<xsl:if test="Fields/Content/FrameRate">
			<content:FrameRate>
				<xsl:value-of select="Fields/Content/FrameRate"/>
			</content:FrameRate>
		</xsl:if>
		<xsl:if test="Fields/Content/Codec">
			<content:Codec>
				<xsl:value-of select="Fields/Content/Codec"/>
			</content:Codec>
		</xsl:if>
		
		<xsl:if test="Fields/Video/BitRate">
			<content:BitRate><xsl:value-of select="Fields/Video/BitRate/@value"/></content:BitRate>
		</xsl:if>
		
		<xsl:if test="Fields/Video/AlternateBitRateList/AlternateBitRate">
			<content:AlternateBitRateResolution>
				<xsl:for-each select="Fields/Video/AlternateBitRateList/AlternateBitRate">
					<content:BitRate>
						<xsl:value-of select="."/>
					</content:BitRate>
				</xsl:for-each>
				<xsl:if test="Fields/Video/AlternateBitRateResolutionList/AlternateBitRateResolution">
					<xsl:for-each select="Fields/Video/AlternateBitRateResolutionList/AlternateBitRateResolution">
						<content:Resolution>
							<xsl:value-of select="."/>
						</content:Resolution>
					</xsl:for-each>
				</xsl:if>
			</content:AlternateBitRateResolution>
		</xsl:if>
		
		<xsl:if test="Fields/Duration/DisplayDuration !='' and normalize-space(Fields/Duration/Duration) =''">
        	<content:Duration>
            	<xsl:apply-templates select="Fields/Duration/DisplayDuration" mode="stringToDuration"/>
        	</content:Duration>
        </xsl:if>
        <xsl:if test="Fields/Duration/Duration !='' and normalize-space(Fields/Duration/DisplayDuration) =''">
        	<content:Duration>
        		<xsl:apply-templates select="Fields/Duration/Duration" mode="stringToDuration"/>
        	</content:Duration>
        </xsl:if>
        <xsl:if test="Fields/Duration/Duration !='' and Fields/Duration/DisplayDuration !=''">
        	<content:Duration>
        		<xsl:apply-templates select="Fields/Duration/Duration" mode="stringToDuration"/>
        	</content:Duration>
        </xsl:if>
		
		<xsl:if test="Fields/Video/HDContent">
			<content:IsHDContent><xsl:value-of select="Fields/Video/HDContent"/></content:IsHDContent>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="$assetType = 'encrypted'">
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='Language']">
					<content:Language>
						<xsl:value-of select="Value"/>
					</content:Language>
				</xsl:for-each>
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='SubTitleLanguage']">
					<content:SubtitleLanguage>
						<xsl:value-of select="Value"/>
					</content:SubtitleLanguage>
				</xsl:for-each>
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='DubbedLanguage']">
					<content:DubbedLanguage>
						<xsl:value-of select="Value"/>
					</content:DubbedLanguage>
				</xsl:for-each>				
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='RatingValue']">
					<content:Rating>
						<xsl:choose>
							<xsl:when test="Fields/CustomFields/CustomField[@name='RatingSystem'] != ''">
								<xsl:attribute name="ratingSystem">
									<xsl:value-of select="Fields/CustomFields/CustomField[@name='RatingSystem']" />
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),Value))"><xsl:attribute name="ratingSystem">MPAA</xsl:attribute></xsl:when>
									<xsl:when test="starts-with(Value,'TV')"><xsl:attribute name="ratingSystem">TV</xsl:attribute></xsl:when>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>										
						<xsl:value-of select="Value"/>
					</content:Rating>
				</xsl:for-each>				
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='MSORating']">
					<content:Rating ratingSystem="MSO">
						<xsl:value-of select="Value"/>
					</content:Rating>
				</xsl:for-each>
				<xsl:for-each select="Fields/CustomFields/CustomField[@name='TargetAudience']">
					<content:Audience>
						<xsl:value-of select="Value"/>
					</content:Audience>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Fields/Languages/Language">
					<content:Language>
						<xsl:value-of select="@value"/>
					</content:Language>
				</xsl:for-each>
				<xsl:for-each select="Fields/SubTitleLanguages/SubTitleLanguage">
					<content:SubtitleLanguage>
						<xsl:value-of select="@value"/>
					</content:SubtitleLanguage>
				</xsl:for-each>
				<xsl:for-each select="Fields/DubbedLanguages/DubbedLanguage">
					<content:DubbedLanguage>
						<xsl:value-of select="@value"/>
					</content:DubbedLanguage>
				</xsl:for-each>		
				<xsl:for-each select="Fields/Rating/RatingValues/RatingValue">
					<content:Rating>
						<xsl:choose> 
							<xsl:when test="System">
								<xsl:attribute name="ratingSystem"><xsl:value-of select="System" /></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),Value))"><xsl:attribute name="ratingSystem">MPAA</xsl:attribute></xsl:when>
									<xsl:when test="starts-with(Value,'TV')"><xsl:attribute name="ratingSystem">TV</xsl:attribute></xsl:when>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="Value"/>
					</content:Rating>
				</xsl:for-each>
				<xsl:for-each select="Fields/Rating/MSORatings/MSORating">
					<content:Rating ratingSystem="MSO">
						<xsl:value-of select="."/>
					</content:Rating>
				</xsl:for-each>
				<xsl:for-each select="Fields/Rating/TargetAudiences/TargetAudience">
					<content:Audience>
						<xsl:value-of select="."/>
					</content:Audience>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
			
		<xsl:if test="Fields/Vendor/Name or Fields/Receiver/Type or Fields/Receiver/Version/Value or Fields/Encryption/Type or Fields/Encryption/Algorithm or Fields/Encryption/Date or Fields/Encryption/Time or Fields/Encryption/SystemInfo or Fields/Encryption/KeyBlock">
			<content:EncryptionInfo>
				<xsl:if test="Fields/Vendor/Name">
					<content:VendorName>
						<xsl:value-of select="Fields/Vendor/Name"/>
					</content:VendorName>
				</xsl:if>
				<xsl:if test="Fields/Receiver/Type">
					<content:ReceiverType>
						<xsl:value-of select="Fields/Receiver/Type"/>
					</content:ReceiverType>
				</xsl:if>
				<xsl:if test="Fields/Receiver/Version/Value">
					<content:ReceiverVersion>
						<xsl:value-of select="Fields/Receiver/Version/Value"/>
					</content:ReceiverVersion>
				</xsl:if>
				<xsl:if test="Fields/Encryption/Type">
					<content:Encryption>
						<xsl:value-of select="Fields/Encryption/Type"/>
					</content:Encryption>
				</xsl:if>
				<xsl:if test="Fields/Encryption/Algorithm">
					<content:EncryptionAlgorithm>
						<xsl:value-of select="Fields/Encryption/Algorithm"/>
					</content:EncryptionAlgorithm>
				</xsl:if>
				<xsl:if test="Fields/Encryption/Date">
					<content:EncryptionDateTime>
						<xsl:choose>
							<xsl:when test="string-length(Fields/Encryption/Time) > 0">
								<xsl:value-of select="concat(substring-before(Fields/Encryption/Date,'T'),'T',Fields/Encryption/Time,'Z')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat(Fields/Encryption/Date, 'Z')" />
							</xsl:otherwise>
						</xsl:choose>
					</content:EncryptionDateTime>
				</xsl:if>
				<xsl:if test="Fields/Encryption/SystemInfo">
					<content:EncryptionSystemInfo>
						<xsl:value-of select="Fields/Encryption/SystemInfo"/>
					</content:EncryptionSystemInfo>
				</xsl:if>
				<xsl:if test="Fields/Encryption/KeyBlock">
					<content:EncryptionKeyBlock>
						<xsl:value-of select="Fields/Encryption/KeyBlock"/>
					</content:EncryptionKeyBlock>
				</xsl:if>
			</content:EncryptionInfo>
		</xsl:if>

		<xsl:if test="$assetType = 'encrypted'">
			<xsl:if test="Fields/CustomFields/CustomField[@name='EncryptionModeIndicator']/IntegerValue or Fields/CustomFields/CustomField[@name='ConstrainedImageTrigger']/IntegerValue or Fields/CustomFields/CustomField[@name='CGMSA']/IntegerValue or Fields/CustomFields/CustomField[@name='CopyProtection']/BooleanValue or Fields/CustomFields/CustomField[@name='CopyProtectionVerbose']/BooleanValue or Fields/CustomFields/CustomField[@name='AnalogProtectionSystem']/IntegerValue or Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue">		
				<content:CopyControlInfo>
					<xsl:if test="Fields/CustomFields/CustomField[@name='CopyProtection']/BooleanValue">
						<content:IsCopyProtection>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='CopyProtection']/BooleanValue"/>
						</content:IsCopyProtection>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='CopyProtectionVerbose']/BooleanValue">
						<content:IsCopyProtectionVerbose>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='CopyProtectionVerbose']/BooleanValue"/>
						</content:IsCopyProtectionVerbose>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='AnalogProtectionSystem']/IntegerValue">
						<content:AnalogProtectionSystem>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='AnalogProtectionSystem']/IntegerValue"/>
						</content:AnalogProtectionSystem>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='EncryptionModeIndicator']/IntegerValue">
						<content:EncryptionModeIndicator>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='EncryptionModeIndicator']/IntegerValue"/>
						</content:EncryptionModeIndicator>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='ConstrainedImageTrigger']/IntegerValue">
						<content:ConstrainedImageTrigger>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='ConstrainedImageTrigger']/IntegerValue"/>
						</content:ConstrainedImageTrigger>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='CGMSA']/IntegerValue">
						<content:CGMS_A>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='CGMSA']/IntegerValue"/>
						</content:CGMS_A>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue">
						<content:RequiresOutputControl>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue"/>
						</content:RequiresOutputControl>
					</xsl:if>
				</content:CopyControlInfo>
			</xsl:if>
		</xsl:if>
		
        <xsl:if test="$assetType != 'encrypted'">
			<xsl:if test="Fields/Copyright/EncryptionModeIndicator or Fields/Copyright/ConstrainedImageTrigger or Fields/Copyright/CGMSA or Fields/Copyright/CopyProtection or Fields/Copyright/CopyProtectionVerbose or Fields/Copyright/AnalogProtectionSystem or Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue">		
				<content:CopyControlInfo>
					<xsl:if test="Fields/Copyright/CopyProtection">
						<content:IsCopyProtection><xsl:value-of select="Fields/Copyright/CopyProtection"/></content:IsCopyProtection>
					</xsl:if>
					<xsl:if test="Fields/Copyright/CopyProtectionVerbose">
						<content:IsCopyProtectionVerbose><xsl:value-of select="Fields/Copyright/CopyProtectionVerbose"/></content:IsCopyProtectionVerbose>
					</xsl:if>
					<xsl:if test="Fields/Copyright/AnalogProtectionSystem">
						<content:AnalogProtectionSystem>
							<xsl:value-of select="Fields/Copyright/AnalogProtectionSystem"/>
						</content:AnalogProtectionSystem>
					</xsl:if>
					<xsl:if test="Fields/Copyright/EncryptionModeIndicator">
						<content:EncryptionModeIndicator>
							<xsl:value-of select="Fields/Copyright/EncryptionModeIndicator"/>
						</content:EncryptionModeIndicator>
					</xsl:if>
					<xsl:if test="Fields/Copyright/ConstrainedImageTrigger">
						<content:ConstrainedImageTrigger>
							<xsl:value-of select="Fields/Copyright/ConstrainedImageTrigger"/>
						</content:ConstrainedImageTrigger>
					</xsl:if>
					<xsl:if test="Fields/Copyright/CGMSA">
						<content:CGMS_A>
							<xsl:value-of select="Fields/Copyright/CGMSA"/>
						</content:CGMS_A>
					</xsl:if>
					<xsl:if test="Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue">
						<content:RequiresOutputControl>
							<xsl:value-of select="Fields/CustomFields/CustomField[@name='Selectable_Output_Control']/BooleanValue"/>
						</content:RequiresOutputControl>
					</xsl:if>
				</content:CopyControlInfo>
			</xsl:if>
		</xsl:if>
		
		<xsl:choose>
		    <xsl:when test="$assetType = 'encrypted'" >
		        <xsl:if test="Fields/CustomFields/CustomField[@name='ViewingCanBeResumed']/BooleanValue">
					<content:IsResumeEnabled><xsl:value-of select="Fields/CustomFields/CustomField[@name='ViewingCanBeResumed']/BooleanValue"/></content:IsResumeEnabled>
				</xsl:if>
		
				<xsl:if test="Fields/CustomFields/CustomField[@name='TrickModeRestriction']/Value">
					<content:TrickModesRestricted>
						<xsl:if test="contains(Fields/CustomFields/CustomField[@name='TrickModeRestriction']/Value, 'FF')">
							<core:TrickModeExclusion type="trick" scale="0.0,100"></core:TrickModeExclusion>
						</xsl:if>
						<xsl:if test="contains(Fields/CustomFields/CustomField[@name='TrickModeRestriction']/Value, 'RW')">
							<core:TrickModeExclusion type="trick" scale="-100,0.0"></core:TrickModeExclusion>
						</xsl:if>
						<xsl:if test="contains(Fields/CustomFields/CustomField[@name='TrickModeRestriction']/Value, 'Pause')">
							<core:TrickModeExclusion type="pause"></core:TrickModeExclusion>
						</xsl:if>
					</content:TrickModesRestricted>
				</xsl:if>
		    </xsl:when>
		    <xsl:otherwise>
		        <xsl:if test="Fields/Rights/ViewingCanBeResumed">
					<content:IsResumeEnabled><xsl:value-of select="Fields/Rights/ViewingCanBeResumed"/></content:IsResumeEnabled>
				</xsl:if>
		
				<xsl:if test="Fields/TrickModeRestrictions/TrickModeRestriction">
					<content:TrickModesRestricted>
						<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'FF')">
							<core:TrickModeExclusion type="trick" scale="0.0,100"></core:TrickModeExclusion>
						</xsl:if>
						<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'RW')">
							<core:TrickModeExclusion type="trick" scale="-100,0.0"></core:TrickModeExclusion>
						</xsl:if>
						<xsl:if test="contains(Fields/TrickModeRestrictions/TrickModeRestriction, 'Pause')">
							<core:TrickModeExclusion type="pause"></core:TrickModeExclusion>
						</xsl:if>
					</content:TrickModesRestricted>
				</xsl:if>
		    </xsl:otherwise>
		</xsl:choose>
		
		<!-- Ext -->
	</xsl:template>

</xsl:stylesheet>