#!/bin/sh

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
SUBSYSTEM_PATH="/opt/tandbergtv/cms/workflow/plugins/subsystems"
envivioPropertiesPath="${SUBSYSTEM_PATH}/envivio-adapter/resources/properties"
fabrixPropertiesPath="${SUBSYSTEM_PATH}/fabrix/resources/properties"

if [ -f ${MIGRATION_TOOL_PATH} ]; then
  envivioPropertiesFileList=`find ${envivioPropertiesPath} -maxdepth 1 -type f | grep ".*\.properties$"`
  for propertiesFile in ${envivioPropertiesFileList};
    do
      echo "Upgrading $propertiesFile"
      python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mode -v " "
      python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mtls.keystore -v "sample.client.keystore.jks"
      python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mtls.truststore -v "sample.client.truststore.jks"
      python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k client.retry.max -v "3"
      python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k client.retry.interval.seconds -v "5"
    done
  
  fabrixPropertiesFileList=`find ${fabrixPropertiesPath} -maxdepth 1 -type f | grep ".*\.properties$"`
  for propertiesFile in ${fabrixPropertiesFileList};
      do
        echo "Upgrading $propertiesFile"
        python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mode -v " "
        python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mtls.keystore -v "sample.client.keystore.jks"
        python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k authentication.mtls.truststore -v "sample.client.truststore.jks"
        python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k client.retry.max -v "3"
        python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${propertiesFile} -k client.retry.interval.seconds -v "5"
      done
fi
