#!/bin/sh

#This shell will modify those files own by CMS, and run in the end of Prepack Installation, no matter it's upgrade or fresh install.
MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
watchfolderProperties="/opt/tandbergtv/cms/conf/watchfolder/watchfolder.properties"
pluginXml="/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/plugin.xml"
CMS_NOTIFICATION_PROPERTIES_FILE="/opt/tandbergtv/cms/plugins/workflow/plugins/com.tandbergtv.workflow.eventhandler.notificationhandler/notification.properties"

backupConfigFile() {
	TIMESTAMP=`date --utc +%Y%m%d%H%M%S`
	backupFile=$1"_ORIG_"$TIMESTAMP
	echo "back up $1 to $backupFile"
	cp -rf "$1" "$backupFile"
}

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${pluginXml} ]; then
	echo "Migrate file $pluginXml"

	backupConfigFile $pluginXml
	python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${pluginXml} -k /plugin-fragment/runtime -v "<library id=\"code_library_autofill_prepack\" path=\"lib/prepack-auto-fill-providers.jar\" type=\"code\" />"
fi

if [ -f "$MIGRATION_TOOL_PATH" ] && [ -f ${watchfolderProperties} ]; then
  backupConfigFile $watchfolderProperties

  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"DefaultInteralWatchfolder\">/content/data/internal_ingest</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"ADIFileName\">ADI.XML</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"AAFMessageUID\">120102</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.ADIVersion\">ISA1.4</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.ADIVODSpecVersion\">CableLabsVOD1.1</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.AMSServerIP\">ACSServer</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.AMSPort\">5000</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.FTPRootDir\">/var/ftp</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.TempDir\">content/data/temp/adi</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.FTPServerIP\">localhost</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.FTPUsername\">ads</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.FTPPassword\">ads123</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"NonAdultVODProcess.AAFMessageUID\">120102</entry>"
  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${watchfolderProperties} -k /properties -v "<entry key=\"FailedFolder\">/var/ftp/content/data/failed</entry>"
fi

if [ -f "$MIGRATION_TOOL_PATH" ] && [ -f ${CMS_NOTIFICATION_PROPERTIES_FILE} ]; then
  python ${MIGRATION_TOOL_PATH} -a REPLACE-ENTRY-VALUE -f ${CMS_NOTIFICATION_PROPERTIES_FILE} -k "notification.template" -v "Send Notification To eCMS"
fi
