<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">

	<xsl:import href="from/offer.xsl"/>
	<xsl:import href="from/title.xsl"/>
	<xsl:import href="from/poster.xsl"/>
	<xsl:import href="from/movie.xsl"/>
	<xsl:import href="from/segmentgroup.xsl"/>
	<xsl:import href="from/signalgrouptype.xsl"/>
			
	<xsl:output method="xml" indent="yes"/>
	
 	<xsl:variable name="Package" select="/ECMFSpec/Package"/>
	<xsl:variable name="PackageProviderId" select="$Package/Fields/ProviderInfo/Identifier/Id"/>
	<xsl:variable name="PackageAssetId" select="$Package/Fields/Identifier/Id"/>
	<xsl:variable name="Title" select="$Package/Title" />
	<xsl:variable name="Display" select="$Package/Display" />
	<xsl:variable name="Movie" select="$Package/Movie" />
	<xsl:variable name="Preview" select="$Package/Preview" />
	<xsl:variable name="Poster" select="$Package/Poster" />
	<xsl:variable name="Boxcover" select="$Package/Boxcover" />
	<xsl:variable name="Barker" select="$Package/Barker" />
	<xsl:variable name="Trick" select="$Package/Trick" />
	<xsl:variable name="Encrypted" select="$Package/Encrypted" />
	<xsl:variable name="TitleProviderId" select="$Title/Fields/ProviderInfo/Identifier/Id"/>
	<xsl:variable name="TitleAssetId" select="$Title/Fields/Identifier/Id"/>
	<xsl:variable name="TermsUriId" select="concat($TitleProviderId, '/Terms/', $TitleAssetId )"/>
	<xsl:variable name="TitleUriId" select="concat($TitleProviderId, '/Title/', $TitleAssetId )"/>
	<xsl:variable name="ContentGroupUriId" select="concat($TitleProviderId, '/ContentGroup/', $TitleAssetId )"/>

	<xsl:variable name="TitleProviderVersionNum" select="$Title/Fields/Version/Major"/>
	<xsl:variable name="TitleInternalVersionNum" select="$Title/Fields/Version/Minor"/>
	
	<xsl:variable name="TitleCreationDateTime">
		<xsl:choose>
			<xsl:when test="string-length($Title/Fields/CreationInfo/CreateDate) = 10">
				<xsl:value-of select="concat($Title/Fields/CreationInfo/CreateDate,'T00:00:00Z')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$Title/Fields/CreationInfo/CreateDate"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	

	<xsl:template match="/">
		<ADI3 
			xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/core/1"  
			xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
			xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
			xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
			xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
			xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"  
			xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 			
			xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
			xmlns:ad="urn:cablelabs:md:xsd:ad:3.0" xmlns:adid="http://www.ad-id.org/schemas/adid/2.0"
			xsi:schemaLocation="http://www.ericsson.com/namespaces/metadata/xsd/COD/1 Ericsson-I01.xsd">
			
			<xsl:apply-templates select="/ECMFSpec/Package" />
			<xsl:apply-templates select="/ECMFSpec/Package/Title" />
			<xsl:apply-templates select="/ECMFSpec/Package/Movie" />
			<xsl:apply-templates select="/ECMFSpec/Package/Preview" />
			<xsl:apply-templates select="/ECMFSpec/Package/Poster" />
			<xsl:apply-templates select="/ECMFSpec/Package/Boxcover" />
			<xsl:apply-templates select="/ECMFSpec/Package/Barker" />
			<xsl:apply-templates select="/ECMFSpec/Package/Trick" />
			<xsl:apply-templates select="/ECMFSpec/Package/Encrypted" />
			<xsl:apply-templates select="/ECMFSpec/Package/MovieSegmentGroup" />
			<xsl:apply-templates select="/ECMFSpec/Package/PreviewSegmentGroup" />
			<xsl:call-template name="SignalGroupType"/>

		</ADI3>
	</xsl:template>

</xsl:stylesheet>