#!/bin/sh

PREFERENCES_PATH="/opt/tandbergtv/cms/workflow/preferences"

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
purgeConfigProfile="${PREFERENCES_PATH}/purge-config.xml"
mkioPackagingProfile="/opt/tandbergtv/cms/workflow/preferences/profiles/mkio-packaging-profile.xml"

mkioPurgeEntry='<entry key="purge.strategy.mkio">MKIO Purge</entry>'
if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${purgeConfigProfile} ]; then
  echo "Upgrading... $purgeConfigProfile"
  python "${MIGRATION_TOOL_PATH}" -a ADD-ENTRY -f ${purgeConfigProfile} -k /properties -v "$mkioPurgeEntry"
fi

if [ -f ${MIGRATION_TOOL_PATH} ] && [ -f ${mkioPackagingProfile} ]; then
  echo "Upgrading.... $mkioPackagingProfile"

  if egrep '<!DOCTYPE properties SYSTEM' "${mkioPackagingProfile}" >/dev/null 2>&1; then
    sed -i '/!DOCTYPE properties SYSTEM/d' ${mkioPackagingProfile}
  else
    echo \"mkio-packaging-profile\" profile has been updated.
  fi
fi

