<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:output method="xml" indent="yes" />

	<xsl:template match="additionalInfo" mode="custom_field">
		<xsl:variable name="cfName" select="@name" />
		<xsl:for-each select="value">
			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">
					<xsl:choose>
						<xsl:when test="./@param and string-length(./@param)!=0">
							<xsl:variable name="attributenameWithDelimiter" select="concat($cfName, '_PARAM_')"/>
							<xsl:value-of select="concat($attributenameWithDelimiter, ./@param)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$cfName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="."></xsl:value-of>
				</xsl:attribute>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="additionalInfo" mode="additional_metadata">
		<xsl:apply-templates select="." mode="custom_field" />
	</xsl:template>
</xsl:stylesheet>
