function check_ssh_to_all_nodes()
{
  K8S_NODE=$(kubectl get node -o wide |grep -v STATUS |awk '{print $6}')
  if [[ -z $K8S_NODE ]]; then
    echo "[Error] kubectl command failed! Make sure the kube-config is configured properly for current user."
    exit 1
  fi
  RPM_PKG=$1
  fail_nodes=""
  skip_install=false
  for NODE in ${K8S_NODE}
  do
    if [[ $(ssh -o StrictHostKeyChecking=no -o BatchMode=yes $NODE "sudo -v" > /dev/null 2>&1; echo $?) -ne 0 ]];then
      fail_nodes="$fail_nodes $NODE"
    fi
  done
  if [[ -n "$fail_nodes" ]]; then
    user_confirm "!! *NOTICE* !! Bootstrap Node is not able to connect to or user has no sudoer configured in below nodes:
$fail_nodes
Do you confirm the below required paths have been created in all kubernete cluster nodes?
 - $DB_LOCAL_VOLUME_PREFIX/cms_db_data/db1
 - $DB_LOCAL_VOLUME_PREFIX/cms_db_data/db2
 - $DB_LOCAL_VOLUME_PREFIX/cms_db_data/db3
 - /var/lib/cms-etcd
Enter 'No' if not. And rerun this step after creating above paths in all nodes by user;
Enter 'Yes' to continue this deployment scripts."
      skip_ssh=true
    fi
}

function delete_k8s_resource(){
    if [[ $(timeout 10 kubectl get $@ > /dev/null 2>&1; echo $?) -eq 0 ]]; then
      echo "[Info] Delete K8S resource $@."
      kubectl delete $@
    fi
}

function init_cms_k8s_resource() {
    # Fetch the cms namespace value from products-var.yaml file
    CMS_NAMESPACE=$(grep "^cms_namespace: " $PRODUCTSVAR_FILE|awk -F ':' '{print $2}'|sed -e 's/ //g' -e 's/"//g')

    # Create CMS namespace
    create_namespace $CMS_NAMESPACE
    
    # In limitedDeployment=false scenario:
    # - generate cms-webhook certificates 
    # - create cms-image-pull-secret
    if ! ${LIMITED_DEPLOYMENT}; then
      if [[ ${K8S_PLATFORM} != "openshift" ]]; then
        # Generate certificate files for cms-webhook
        echo "[INFO] Generating CMS cluster signed certificate for cms-webhook"
        if [[ -z "$CLOUDPLATFORM" ]] || $RUN_AS_CONTAINER; then
          gen_self_cert "cms-webhook" $CMS_NAMESPACE ""
        else
          gen_self_cert "cms-webhook" "$CMS_NAMESPACE" "$CLOUD_CLUSTER_INSTANCE_NAME"
        fi
        echo "[INFO] Update products-var with new tls values for cms-webhook"
        #yq w -i ${PRODUCTSVAR_FILE} 'cms_webhook.ca_crt' "${SELF_CA_CRT}"
        #yq w -i ${PRODUCTSVAR_FILE} 'cms_webhook.tls_crt' "${SELF_TLS_CRT}"
        #yq w -i ${PRODUCTSVAR_FILE} 'cms_webhook.tls_key' "${SELF_TLS_KEY}"
  
        #change to yq4
        yq -i ".cms_webhook.ca_crt=\"${SELF_CA_CRT}\"" ${PRODUCTSVAR_FILE}
        yq -i ".cms_webhook.tls_crt=\"${SELF_TLS_CRT}\"" ${PRODUCTSVAR_FILE}
        yq -i ".cms_webhook.tls_key=\"${SELF_TLS_KEY}\"" ${PRODUCTSVAR_FILE}
      fi
  
      # The create elastic-tls secret part is moved to init-config step
           
      # Create CMS ImagePullSecret
      #if [[ "$(yq r $PRODUCTSVAR_FILE 'imagePullSecrets[0].name')" == "$IMAGE_PULL_SECRET_NAME" ]] && [[ -z "$(kubectl get secret -n $CMS_NAMESPACE | grep -o "^$IMAGE_PULL_SECRET_NAME ")" ]]; then
      if [[ "$(yq '.imagePullSecrets[0].name' $PRODUCTSVAR_FILE)" == "$IMAGE_PULL_SECRET_NAME" ]] && [[ -z "$(kubectl get secret -n $CMS_NAMESPACE | grep -o "^$IMAGE_PULL_SECRET_NAME ")" ]]; then
        if [[ -n "$IMAGE_REGISTRY" ]]; then
          if ([[ -n "$IMAGE_PULL_USER" ]] && [[ -z "$IMAGE_PULL_PASSWORD" ]]) || ([[ -z "$IMAGE_PULL_USER" ]] && [[ -n "$IMAGE_PULL_PASSWORD" ]]); then
            echo "[Error] One of image_pull_user and image_pull_password is empty, ensure both variables have values provided before rerun."
            exit 1
          elif [[ -n "$IMAGE_PULL_USER" ]] && [[ -n "$IMAGE_PULL_PASSWORD" ]]; then
            echo "[INFO] Create $IMAGE_PULL_SECRET_NAME."
            kubectl create -n $CMS_NAMESPACE secret docker-registry $IMAGE_PULL_SECRET_NAME \
              --docker-server=$IMAGE_REGISTRY \
              --docker-username=$IMAGE_PULL_USER \
              --docker-password=$IMAGE_PULL_PASSWORD
            kubectl patch serviceaccount default -n "$CMS_NAMESPACE" --type=merge -p "{\"imagePullSecrets\":[{\"name\":\"$IMAGE_PULL_SECRET_NAME\"}]}"          fi
        fi
      fi
    fi

    # Create StorageClass on GKE
    if [[ ${CLOUDPLATFORM} == "GCP" ]]; then
      # Create GKE StorageClass for Database
      if [[ $DEV_MODE == "false" ]]; then
      # For production, create the StorageClass as regional, and with SSD disk.
         sc_type="pd-ssd"
         replication_type="regional-pd"
      else
         sc_type="pd-standard"
         replication_type="none"
      fi
      echo "[INFO] Create CMS StorageClass cms-disk with type [$sc_type] and replication-type [$replication_type]."
  
      cat <<- EOF | kubectl apply -f -
		allowVolumeExpansion: true
		apiVersion: storage.k8s.io/v1
		kind: StorageClass
		metadata:
		  name: ${CMS_NAMESPACE}
		  annotations:
		    storageclass.kubernetes.io/is-default-class: "false"
		  labels:
		    addonmanager.kubernetes.io/mode: EnsureExists
		    kubernetes.io/cluster-service: "true"
		  name: cms-disk
		parameters:
		  type: ${sc_type}
		  replication-type: ${replication_type}
		provisioner: kubernetes.io/gce-pd
		reclaimPolicy: Delete
		volumeBindingMode: WaitForFirstConsumer
		EOF

    fi # End create StorageClass on GKE


    # Create StorageClass on AKS
    if [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
      EXISTING_SC=$(kubectl get sc --request-timeout 60s|awk '{print $1}')

      if [[ "${USE_AZURE_FILE_STORAGE}" == "true" ]]; then
        AZURE_STORAGE_ACCOUNT_NAME=$(grep OUTPUT_STORAGEACCOUNT_NAME ${CLOUD_ENV} | awk -F '=' '{print $2}')
        if [[ -z $EXISTING_SC ]]; then
          [Error] Can not fetch StorageClass information from the AKS cluster.
          exit 1
        fi
        #Bypass the cms-azure-file SC update if the SC exist!
        if [[ -z $(echo "$EXISTING_SC"|grep '^cms-azure-file$') ]]; then
  
        ## [TODO] seperate definition for dev and production mode?
        #if [[ $DEV_MODE == "false" ]]; then
        #  SC_SKU="Premium_LRS"
        #else
        #  SC_SKU="Standard_LRS"
        #fi
        echo "[Info] Creating cms-azure-file StorageClass with storageaccount [$AZURE_STORAGE_ACCOUNT_NAME]."
  
        # Create AKS StorageClass for all CMS PVC
        cat <<EOF | kubectl apply -f -
kind: StorageClass
apiVersion: storage.k8s.io/v1
metadata:
  name: cms-azure-file
provisioner: file.csi.azure.com
allowVolumeExpansion: true
mountOptions:
  - dir_mode=0777
  - file_mode=0777
  - uid=99
  - gid=99
  - mfsymlinks
  - cache=strict
parameters:
  # If a storage account is provided, it must reside in the same resource group as the cluster, 
  # and skuName and location are ignored.
  #skuName: ${SC_SKU}
  storageAccount: $AZURE_STORAGE_ACCOUNT_NAME
  resourcegroup: $RESOURCEGROUP_NAME
EOF
        fi # End create StorageClass [cms-azure-file]
  
        # Prepare Azure StorageClass for static auzre-file shares
        prepare_azure_file_static_sc="false"
        # For upgrade case
        if [[ -n $(echo "$EXISTING_SC"|grep ^cms-azure-file$) ]]; then
          if [[ -n $(echo "$EXISTING_SC"|grep ^azure-file-cms-conf$) ]]; then
            # set to true if the system was fresh installed with static PV SCs.
            prepare_azure_file_static_sc="true"
          fi
        # For fresh installation case
        else
          prepare_azure_file_static_sc="true"
        fi
  
        if  [[ "$prepare_azure_file_static_sc" == "true" ]]; then
          echo "[Info] Start preparing StorageClasses for static azure-file shares."
          for sharename in $AZUREFILE_SHARES;
          do
            # Create StorageClass only when not existing
            if [[ -z $(echo "$EXISTING_SC"|grep "^azure-file-$sharename$") ]];then
              echo "[Info] Creating StorageClass azure-file-$sharename."
              cat <<EOF | kubectl apply -f -
kind: StorageClass
apiVersion: storage.k8s.io/v1
metadata:
  name: azure-file-${sharename}
provisioner: file.csi.azure.com
allowVolumeExpansion: true
reclaimPolicy: Retain
mountOptions:
  - dir_mode=0755
  - file_mode=0755
  - uid=99
  - gid=99
  - mfsymlinks
  - cache=strict
parameters:
  # If a storage account is provided, it must reside in the same resource group as the cluster, 
  # and skuName and location are ignored.
  #skuName: ${SC_SKU}
  storageAccount: $AZURE_STORAGE_ACCOUNT_NAME
  resourcegroup: $RESOURCEGROUP_NAME
  shareName: ${sharename}
EOF
            fi
          done
        fi # End Prepare Azure StorageClass for static auzre-file shares
      fi # End USE_AZURE_FILE_STORAGE

      #Need to bypass the cms-disk SC update if the SC exist!
      if [[ -z $(echo "$EXISTING_SC"|grep '^cms-disk$') ]]; then
        echo "[Info] Creating cms-disk StorageClass with storageaccounttype [$SC_SKU]."
        # Create AKS StorageClass for Database/ETCD/Logstash/RabbitMQ instances
        cat <<EOF | kubectl apply -f -
kind: StorageClass
apiVersion: storage.k8s.io/v1
metadata:
  name: cms-disk
provisioner: disk.csi.azure.com
allowVolumeExpansion: true
reclaimPolicy: Delete
volumeBindingMode: WaitForFirstConsumer
parameters:
  storageaccounttype: ${SC_SKU}
  kind: Managed
EOF
      fi # End create StorageClass [cms-disk]

    fi # End create StorageClass on AKS


    # Create PV on Bare Metal setup for Databases
    # Not to create in limited_deployment=true scenario
    # Not to create when storageclass_name has value
    if [[ ${CLOUDPLATFORM} == "" ]] && ! ${LIMITED_DEPLOYMENT} && [[ -z ${STORAGECLASS_NAME} ]]; then
    check_ssh_to_all_nodes
    
    # Create Storage Class for Database specific host-volume PV
    cat <<EOF | kubectl apply -f -
kind: StorageClass
apiVersion: storage.k8s.io/v1
metadata:
  name: cms-db-local-storage
provisioner: kubernetes.io/no-provisioner
volumeBindingMode: WaitForFirstConsumer
EOF

    #DB_NODES=$(cat $MATRIXFILE | yq r - '(profiles[*].name==cms-db-*))' | grep node | awk '{print $2}' | xargs)
    #DB_NODES_AMOUNT=$(cat $MATRIXFILE | yq r - '(profiles[*].name==cms-db-*))' | grep node | wc -l)
    DB_NODES=$(cat $MATRIXFILE | yq '(.[]|select(.profiles[].name=="cms-db-*"))' - | grep node | awk '{print $2}' | xargs)
    DB_NODES_AMOUNT=$(cat $MATRIXFILE | yq '(.[]|select(.profiles[].name=="cms-db-*"))' - | grep node | wc -l)
    for dbnode in $DB_NODES; do
      # Create folder for database host-volume PV on all nodes running database PODs
      # This require the cluster to meet the prerequisite for admin user to ssh to all nodes without asking password, and also the sudoer property.
      ip=$(timeout 10 kubectl get node -o wide |grep "$dbnode "|awk '{print $6}')
      if [[ $DB_NODES_AMOUNT -gt 2 ]]; then
        pv_num=2
      else
        pv_num=3
      fi

      #[TODO]Create Database specific host-volume PV
      for (( i=1; i<=$pv_num; i++ )); do
        if [[ ! $skip_ssh ]];then
          ssh -o StrictHostKeyChecking=no $ip "
            sudo mkdir -p $DB_LOCAL_VOLUME_PREFIX/cms_db_data/db$i
          "
        fi
        cat <<EOF | kubectl apply -f -
apiVersion: v1
kind: PersistentVolume
metadata:
  name: $dbnode-cms-local-db$i
spec:
  capacity:
    storage: 1000Gi
  accessModes:
  - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  storageClassName: cms-db-local-storage
  local:
    path: $DB_LOCAL_VOLUME_PREFIX/cms_db_data/db$i
  nodeAffinity:
    required:
      nodeSelectorTerms:
      - matchExpressions:
        - key: kubernetes.io/hostname
          operator: In
          values:
          - $dbnode
EOF

      done  # End for i
    
    done # End for dbnode

    fi # End create PV on Bare Metal setup for Databases

    # Create PV on Bare Metal setup for ETCD
    # Not to create in limited_deployment=true scenario
    # Not to create when storageclass_name has value
    if [[ ${CLOUDPLATFORM} == "" ]] && ! ${LIMITED_DEPLOYMENT} && [[ -z ${STORAGECLASS_NAME} ]]; then
    # Create Storage Class for ETCD specific host-volume PV
    cat <<EOF | kubectl apply -f -
kind: StorageClass
apiVersion: storage.k8s.io/v1
metadata:
  name: cms-etcd-local-storage
provisioner: kubernetes.io/no-provisioner
reclaimPolicy: Delete
volumeBindingMode: WaitForFirstConsumer
EOF

    #ETCD_NODES=$(cat $MATRIXFILE | yq r - '(profiles[*].name==cms-etcd))' | grep node | awk '{print $2}' | xargs)
    ETCD_NODES=$(cat $MATRIXFILE | yq '(.[]|select(.profiles[].name=="cms-etcd"))' - | grep node | awk '{print $2}' | xargs)
    for etcdnode in $ETCD_NODES; do
      # Create folder for etcd host-volume PV on all nodes running etcd PODs
      # This require the cluster to meet the prerequisite for admin user to ssh to all nodes without asking password, and also the sudoer property.
      ip=$(timeout 10 kubectl get node -o wide |grep "$etcdnode "|awk '{print $6}')

      #[TODO]Create ETCD specific host-volume PV
        if [[ ! $skip_ssh ]];then
          ssh -o StrictHostKeyChecking=no $ip "
            sudo mkdir -p /var/lib/cms-etcd
          "
        fi
      cat <<EOF | kubectl apply -f -
apiVersion: v1
kind: PersistentVolume
metadata:
  name: $etcdnode-cms-local-etcd
spec:
  capacity:
    storage: 8Gi
  accessModes:
  - ReadWriteOnce
  persistentVolumeReclaimPolicy: Retain
  storageClassName: cms-etcd-local-storage
  local:
    path: /var/lib/cms-etcd
  nodeAffinity:
    required:
      nodeSelectorTerms:
      - matchExpressions:
        - key: kubernetes.io/hostname
          operator: In
          values:
          - $etcdnode
EOF
  
    done # End for etcdnode

    fi # End create PV on Bare Metal setup for ETCD
}

function deploy_products() {
    [[ $1 != "-h" && $1 != "--help" ]] && beginLogging "Start Deploying CMS into cluster."

    reset_function_timer

    # Fetch the cms namespace value from products-var.yaml file
    CMS_NAMESPACE=$(grep "^cms_namespace: " $PRODUCTSVAR_FILE|awk -F ':' '{print $2}'|sed -e 's/ //g' -e 's/"//g')
    
    if [[ ${CLOUDPLATFORM} == "AZURE" ]];then
      # Login to azure to ensure using the expected account and subsciption from the bootstrap node.
      #azure_login
      azure_get_aks_credentials
    fi

    # Only prepare storageclass and database PVs when deploying with default matrix file
    if [[ "$1" == "-mx" ]] && [[ "$2" == "products-matrix.yaml" ]]; then
      init_cms_k8s_resource
    fi
    
    if ! $RUN_AS_CONTAINER ; then
      #Set the alias for cmscli on the bastion machine
      #if [[ -n "${CLOUDPLATFORM}" ]]; then
      sed -i '/alias cmscli=/d' ~/.bashrc
      echo 'alias cmscli="kubectl exec -i -n '$CMS_NAMESPACE' cms-cli-0 -c cms-cli -- cmscli"' >> ~/.bashrc
      sed -i '/alias cmsgeocli=/d' ~/.bashrc
      echo 'alias cmsgeocli="kubectl exec -it -n '$CMS_NAMESPACE' cms-geo-cli-0 -c cms-geo-cli -- geocli"' >> ~/.bashrc
      source ~/.bashrc
      #fi
    fi

    if ${LIMITED_DEPLOYMENT} || ! ${ALLOW_CREATE_NODE_LABEL}; then
      #echo "[INFO] Bypass Nodes labeling in limited deployment scenario."
      cd ${SCRIPTPATH} && python install.py $@ --without-node-label
    else
      cd ${SCRIPTPATH} && python install.py $@
    fi

    [[ $1 != "-h" && $1 != "--help" ]] && running_time
}

function reset_products() {
    beginLogging "Start Reset CMS from cluster."

    reset_function_timer

    if [[ ${CLOUDPLATFORM} == "AZURE" ]];then
      # Login to azure to ensure using the expected account and subsciption from the bootstrap node.
      #azure_login
      azure_get_aks_credentials
    fi

    # Get mdt-cli POD name
    #get_mdt_cli_pod
    
    #kubectl exec -n ${MDT_NAMESPACE} ${MDT_CLI} -- mdt reset products

    #Clean all cms PVCs and PVs
    
    #Delete charts
    set +e
    cd ${SCRIPTPATH}
    python install.py --reset products-matrix.yaml 2>&1
    if [[ $? -ne 0 ]]; then
      if [[ "$1" != "all" ]]; then
        exit 1 
      else
        user_confirm "Now Delete the whole namespace regardless the chart delete errors."
      fi
    fi
    set -e  

    if [ "$1" == "all" ]; then
      CMS_NAMESPACE=$(grep "^cms_namespace: " $PRODUCTSVAR_FILE|awk -F ':' '{print $2}'|sed -e 's/ //g' -e 's/"//g')
          
      #Delete the whole namespace
      echo "[Info] Deleting CMS namespace [$CMS_NAMESPACE]."
      if [[ $(kubectl get ns $CMS_NAMESPACE > /dev/null 2>&1; echo $?) -eq 0 ]]; then
         kubectl delete ns $CMS_NAMESPACE >&/dev/null&
      fi 
      
      while [[ $(kubectl get ns $CMS_NAMESPACE > /dev/null 2>&1; echo $?) -eq 0 ]]
      do
        sleep_pot 15
      done
      #echo "[Info] Delete all CMS existing Jobs."
      #timeout 10 kubectl get job -n $CMS_NAMESPACE|awk '{print $1}'|grep -v NAME| xargs kubectl delete job -n $CMS_NAMESPACE
  
      #echo "[Info] Delete all CMS PVCs."
      #sleep_pot 30
      #timeout 10 kubectl get pvc -n $CMS_NAMESPACE|awk '{print $1}'|grep -v NAME| xargs kubectl delete pvc -n $CMS_NAMESPACE
  
      echo "[Info] Delete all remained CMS PVs."
      sleep_pot 20
      if [[ -n $(timeout 10 kubectl get pv|grep " $CMS_NAMESPACE/") ]]; then
        timeout 10 kubectl get pv|grep " $CMS_NAMESPACE/" |awk '{print $1}'| xargs kubectl delete pv >&/dev/null&
      fi

      if [[ -n $(timeout 10 kubectl get pv|grep "cms-local-db") ]]; then
        timeout 10 kubectl get pv|grep "cms-local-db" |awk '{print $1}'| xargs kubectl delete pv >&/dev/null&
      fi

      echo "[Info] Delete CMS StorageClass [cms-data]."
      if [[ -n $(timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-data$) ]]; then
        timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-data$| xargs kubectl delete sc
      fi
      if [[ ${CLOUDPLATFORM} == "AZURE" ]]; then
        EXISTING_SC=$(kubectl get sc --request-timeout 60s|grep -v NAME|awk '{print $1}')
        if [[ -n $(echo "$EXISTING_SC"|grep ^cms-disk$) ]]; then
          echo "[Info] Delete CMS StorageClass [cms-disk]."
          timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-disk$| xargs kubectl delete sc
        fi    
        if [[ -n $(echo "$EXISTING_SC"|grep ^cms-azure-file$) ]]; then
          echo "[Info] Delete CMS StorageClass [cms-azure-file]."
          timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-azure-file$| xargs kubectl delete sc
        fi
        if [[ "${USE_AZURE_FILE_STORAGE}" == "true" ]]; then
          for sharename in $AZUREFILE_SHARES;
          do
            if [[ -n $(echo "$EXISTING_SC"|grep ^azure-file-$sharename$) ]]; then
              echo "[Info] Delete CMS StorageClass [azure-file-$sharename]."
              timeout 10 kubectl get sc|awk '{print $1}'|grep ^azure-file-$sharename$| xargs kubectl delete sc
            fi
          done
        fi
      fi

      if [[ ${CLOUDPLATFORM} == "GCP" ]]; then
        echo "[Info] Delete CMS StorageClass [cms-disk]."
        if [[ -n $(timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-disk$) ]]; then
          timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-disk$| xargs kubectl delete sc
        fi
      fi

      if [[ ${CLOUDPLATFORM} == "" ]]; then
        echo "[Info] Delete CMS StorageClass [cms-db-local-storage]."
        if [[ -n $(timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-db-local-storage$) ]]; then
          timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-db-local-storage$| xargs kubectl delete sc
        fi
        echo "[Info] Delete CMS StorageClass [cms-etcd-local-storage]."
        if [[ -n $(timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-etcd-local-storage$) ]]; then
          timeout 10 kubectl get sc|awk '{print $1}'|grep ^cms-etcd-local-storage$| xargs kubectl delete sc
        fi    
      fi

      echo "[Info] Delete all CMS Related ClusterRole."
      delete_k8s_resource ClusterRole cms-nfs-runner
      delete_k8s_resource ClusterRole cms-filebeat-cms-filebeat-cluster-role
      delete_k8s_resource ClusterRole cms-kube-state-metrics
      delete_k8s_resource ClusterRole cms-metricbeat-cms-metricbeat-cluster-role
      #[[ $(kubectl get ClusterRole cms-nfs-runner > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRole cms-nfs-runner
      #[[ $(kubectl get ClusterRole cms-filebeat-cms-filebeat-cluster-role > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRole cms-filebeat-cms-filebeat-cluster-role
      #[[ $(kubectl get ClusterRole cms-kube-state-metrics > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRole cms-kube-state-metrics
      #[[ $(kubectl get ClusterRole cms-metricbeat-cms-metricbeat-cluster-role > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRole cms-metricbeat-cms-metricbeat-cluster-role
  
      echo "[Info] Delete all CMS Related ClusterRoleBinding."
      delete_k8s_resource ClusterRoleBinding run-cms-nfs
      delete_k8s_resource ClusterRoleBinding cms-haproxy
      delete_k8s_resource ClusterRoleBinding cms-filebeat-cms-filebeat-cluster-role-binding
      delete_k8s_resource ClusterRoleBinding cms-kube-state-metrics
      delete_k8s_resource ClusterRoleBinding cms-metricbeat-cms-metricbeat-cluster-role-binding
      #[[ $(kubectl get ClusterRoleBinding run-cms-nfs > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRoleBinding run-cms-nfs
      #[[ $(kubectl get ClusterRoleBinding cms-haproxy > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRoleBinding cms-haproxy
      #[[ $(kubectl get ClusterRoleBinding cms-filebeat-cms-filebeat-cluster-role-binding > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRoleBinding cms-filebeat-cms-filebeat-cluster-role-binding
      #[[ $(kubectl get ClusterRoleBinding cms-kube-state-metrics > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRoleBinding cms-kube-state-metrics
      #[[ $(kubectl get ClusterRoleBinding cms-metricbeat-cms-metricbeat-cluster-role-binding > /dev/null 2>&1; echo $?) -eq 0 ]] && kubectl delete ClusterRoleBinding cms-metricbeat-cms-metricbeat-cluster-role-binding 
    fi

    running_time
}
