# cms-cli

[cms-cli]CMS centralized command for mantaining cms services such as restart service, stop service.

## TL;DR;

```bash
$ helm install helm_repo/cms-cli
```

## Introduction


## Prerequisites

- Kubernetes 1.4+ with Beta APIs enabled

## Installing the Chart

To install the chart with the release name `my-release`:

```bash
$ helm install --name my-release helm_repo/cms-cli
```

Test command
```bash
$ cd /root/cms-container-tools/chart
$ helm install --tls --host=localhost:30010 --name=cms-cli --values=cms-cli-values.yaml --debug ./cms-cli
```

> **Tip**: List all releases using `helm list`

## Uninstalling the Chart

To uninstall/delete the `my-release` deployment:

```bash
$ helm delete my-release
```

The command removes all the Kubernetes components associated with the chart and deletes the release.

## Configuration

The following tables lists the configurable parameters of the cms-container-tools chart and their default values.

|           Parameter           |                Description                       |           Default            |
|-------------------------------|--------------------------------------------------|------------------------------|
| `image.repository`            | Dock image repository                            | `""`                         |
| `image.tag`                   | Dock image tag                                   | `latest`                     |
| `image.PullPolicy`            | Image pull policy                                | `IfNotPresent`               |
| `resources.requests.memory`   | Resource memory request                          | `128Mi`                      |
| `resources.requests.cpu`      | Resource cpu request                             | `100m`                       |
| `resources.limits.memory`     | Resource memory limit                            | `256Mi`                      |
| `resources.limits.cpu`        | Resource cpu limit                               | `200m`                       |
| `updateStrategy`              | Pod update strategy                              | `RollingUpdate`              |
| `remoteKubeConfigBase64`      | Kubectl config file content as Base64 encoded string   | `""`                         |
| `has_external_ct`             | Has an external CT node or not                   | `false`                      |

## NetworkPolicy


## Persistence


### Existing PersistentVolumeClaim

