/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.blackout.publisher;

import com.ericsson.cms.epgmgmt.blackout.publisher.ESNIClient;
import com.ericsson.cms.epgmgmt.blackout.publisher.ESNITemplate;
import com.ericsson.cms.epgmgmt.blackout.publisher.PluginInfo;
import com.ericsson.cms.epgmgmt.entity.Schedule;
import com.ericsson.cms.epgmgmt.entity.SchedulePK;
import com.ericsson.cms.epgmgmt.log.IActivityLogger;
import com.ericsson.cms.epgmgmt.plugin.AbstractEPGPlugin;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.ExportTaskInfo;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.IInsidePluginReceiver;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import com.ericsson.epgmgr.plugin.PluginProperty;
import com.ericsson.epgmgr.plugin.enumeration.GraphicSupportEnum;
import com.ericsson.epgmgr.plugin.util.PluginPropertyUtil;
import com.google.common.collect.Maps;
import com.mediakind.neptune.common.http.exception.RequestException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.StopWatch;

public class BlackoutPublisher
extends AbstractEPGPlugin
implements IEPGManagerPublisher,
IInsidePluginReceiver {
    private static final Logger logger = LoggerFactory.getLogger((String)BlackoutPublisher.class.getName());
    public static final String PROPERTY_ERR_SUFFIX = ".error";
    public static final String PRISMA_BASE_URL = "PRISMA_BASE_URL";
    public static final String PRISMA_INIT_FLAG = "PRISMA_INIT_FLAG";
    public static final String MEDIA_TO_CHANNEL_MAP_PATH = "MEDIA_TO_CHANNEL_MAP_PATH";
    public static final String MEDIA_TO_CHANNEL_MAP = "MEDIA_TO_CHANNEL_MAP";
    public static final String MEDIA_TO_CHANNEL_MAP_DELIMITER = ";";
    public static final String True = Boolean.TRUE.toString();
    public static final String False = Boolean.FALSE.toString();
    public static final String noBlackoutScheduleId = "noBlackout";
    private final Map<String, Object> status = Maps.newHashMap();
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private final SimpleDateFormat Iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private boolean isCanceled = false;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private ExportTaskInfo info;

    public BlackoutPublisher() {
        this.Iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getName() {
        return "blackout";
    }

    public boolean toEPGFormat(String epgSourceFileName, String epgTargetFileName, List<PluginProperty> pluginProperties) throws EPGPluginException {
        try {
            String receiverProviderIdFromTask = (String)this.info.getTriggerSetting().get("trigger.setting.provider.id");
            if (StringUtils.isBlank((String)receiverProviderIdFromTask)) {
                throw new EPGPluginException("Receiver provider id is not configured.");
            }
            long receiverProviderId = Long.parseLong(receiverProviderIdFromTask);
            StopWatch watch = new StopWatch();
            watch.start();
            this.setProgress(0);
            String prismaBaseUrl = PluginPropertyUtil.getPluginProperty(pluginProperties, (String)PRISMA_BASE_URL);
            boolean prismaInitFlag = Boolean.parseBoolean(PluginPropertyUtil.getPluginProperty(pluginProperties, (String)PRISMA_INIT_FLAG));
            String mappingsPath = PluginPropertyUtil.getPluginProperty(pluginProperties, (String)MEDIA_TO_CHANNEL_MAP_PATH);
            String mappingsProperty = PluginPropertyUtil.getPluginProperty(pluginProperties, (String)MEDIA_TO_CHANNEL_MAP);
            Map<String, String> mediaIdMaps = this.buildMediaIdMap(mappingsPath, mappingsProperty);
            Map<String, Set<String>> channelIdMaps = this.buildChannelIdMap(mediaIdMaps);
            List<Schedule> schedules = this.getBlackoutSchedules(receiverProviderId);
            logger.info("Publishing to Prisma using URL {}, init={}, scheduleCount={}, mediaIdMapsCount={} for receiver providerId={}", new Object[]{prismaBaseUrl, prismaInitFlag, schedules.size(), mediaIdMaps.size(), receiverProviderIdFromTask});
            if (schedules.isEmpty()) {
                logger.warn("No blackout schedule found");
            }
            if (mediaIdMaps.isEmpty()) {
                logger.error("No MediaId to ChannelId mapping configured");
                throw new EPGPluginException("Missing MediaId to ChannelId mapping configuration.");
            }
            this.setProgress(10);
            this.initPrismaResources(prismaInitFlag, prismaBaseUrl);
            this.ConfigureMediaPoints(prismaBaseUrl, schedules, mediaIdMaps, channelIdMaps);
            logger.info("toEPGFormat() creating a file with name {}", (Object)epgTargetFileName);
            FileWriter myWriter = new FileWriter(epgTargetFileName);
            myWriter.write("Prisma interaction will be done via HTTP");
            myWriter.close();
            watch.stop();
            logger.info("Prisma interaction completed in {} seconds.", (Object)watch.getTotalTimeSeconds());
            this.setProgress(100);
            return true;
        }
        catch (EPGPluginException ex) {
            logger.error("Some error occurred and error is {}" + ex.getMessage());
            throw ex;
        }
        catch (IOException ioex) {
            logger.error("Some error occurred and error is {}" + ioex.getMessage());
            throw new EPGPluginException(ioex.getMessage(), (Throwable)ioex);
        }
        catch (Exception ex) {
            logger.error("Some error occurred and error is {}" + ex.getMessage());
            throw new EPGPluginException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean deliverEPGData(List<File> list, List<PluginProperty> pluginProperties) throws EPGPluginException {
        return true;
    }

    public Map<PluginAttribute, String> getAttributes() {
        HashMap attributeMap = Maps.newHashMap();
        attributeMap.put(PluginAttribute.INFO, "Blackout Receiver Plug-in");
        attributeMap.put(PluginAttribute.VALIDATE, "false");
        attributeMap.put(PluginAttribute.ETV_FORMAT, PluginInfo.ETV_FORMAT);
        return attributeMap;
    }

    public String getFormat() throws EPGPluginException {
        return "BLACKOUT";
    }

    public String getVersion() {
        return "10.3.0";
    }

    public boolean validateProperties(List<PluginProperty> properties) throws EPGPluginException {
        boolean isValid = true;
        try {
            for (PluginProperty pp : properties) {
                if (!pp.getName().equalsIgnoreCase(PRISMA_INIT_FLAG)) continue;
                String value = pp.getConfiguredValue();
                if (value == null || !value.equalsIgnoreCase(True) && !value.equalsIgnoreCase(False)) {
                    pp.setErrorMessage(this.getProps().getProperty(pp.getName() + PROPERTY_ERR_SUFFIX));
                }
                if (pp.getErrorMessage() == null || pp.getErrorMessage().length() <= 0) continue;
                isValid = false;
            }
        }
        catch (Exception ex) {
            logger.error("error found while validating configured values for plug-in.", (Throwable)ex);
            isValid = false;
        }
        return isValid;
    }

    public void setJobId(String jobId) {
    }

    public void cancel() {
        logger.info("Cancelling Blackout Publisher Pluging task");
        this.isCanceled = true;
    }

    public Map<String, Object> getPluginStatus() {
        this.status.put("isCanCancelPluginKey", true);
        return this.status;
    }

    public boolean isLicenseMandatory() {
        return true;
    }

    public String getLicenseName() {
        return "BLACKOUT";
    }

    public void addDataSource(String name, DataSource dataSource) {
        this.dataSources.put(name, dataSource);
    }

    public void setExportTaskInfo(ExportTaskInfo info) {
        this.info = info;
    }

    public void setActivityLogger(IActivityLogger arg0) {
    }

    public Map<String, Object> publishSettingAttribute() {
        HashMap settingMap = Maps.newHashMap();
        settingMap.put("DATA_INTEGRITY_VALUE", "false");
        settingMap.put("DATA_INTEGRITY_SHOW", "false");
        settingMap.put("OUTPUT_GRAPHIC_SUPPORT", GraphicSupportEnum.NOT_SUPPORT.name());
        settingMap.put("IS_EXPORT_TO_FOLDER", "false");
        return settingMap;
    }

    private void checkCancel() {
        if (this.isCanceled) {
            logger.info("checkCancel() generate a CancellationException");
            throw new CancellationException();
        }
    }

    private DataSource getPostgresDataSource() {
        DataSource dataSource = this.dataSources.get("dataSource");
        if (dataSource == null) {
            throw new EPGPluginException("The postgres data source is not available");
        }
        return dataSource;
    }

    public void setJdbcTemplate(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new NamedParameterJdbcTemplate(this.getPostgresDataSource());
        }
        return this.jdbcTemplate;
    }

    private void setProgress(int percentage) {
        this.checkCancel();
        if (this.getStatusMonitor() != null) {
            this.getStatusMonitor().setProgress(percentage);
        }
    }

    private Map<String, String> buildMediaIdMap(String propertiesFile, String propertiesFromString) throws EPGPluginException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (propertiesFile != null && !propertiesFile.isEmpty()) {
                try {
                    FileReader reader = new FileReader(propertiesFile);
                    Properties properties = new Properties();
                    properties.load(reader);
                    for (Object key : properties.keySet()) {
                        String mediaId = ((String)key).trim();
                        map.put(mediaId, properties.getProperty(mediaId).trim());
                    }
                }
                catch (IOException reader) {
                    // empty catch block
                }
            }
            if (map.isEmpty() && propertiesFromString != null && !propertiesFromString.isEmpty()) {
                Properties properties = new Properties();
                properties.load(new StringReader(propertiesFromString.replaceAll(MEDIA_TO_CHANNEL_MAP_DELIMITER, "\n")));
                for (Object key : properties.keySet()) {
                    String mediaId = ((String)key).trim();
                    map.put(mediaId, properties.getProperty(mediaId).trim());
                }
                if (!map.isEmpty()) {
                    logger.warn("No mapping found from the input file, using values from property MEDIA_TO_CHANNEL_MAP instead");
                }
            }
            return map;
        }
        catch (IOException e) {
            logger.error("toEPGExport IOException found", (Throwable)e);
            throw new EPGPluginException((Throwable)e);
        }
    }

    private Map<String, Set<String>> buildChannelIdMap(Map<String, String> mediaIdMap) throws EPGPluginException {
        HashMap<String, Set<String>> channelIdMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : mediaIdMap.entrySet()) {
            String mediaId = entry.getKey();
            String channelId = entry.getValue();
            HashSet<String> mediaIds = (HashSet<String>)channelIdMap.get(channelId);
            if (mediaIds == null) {
                mediaIds = new HashSet<String>();
                channelIdMap.put(channelId, mediaIds);
            }
            mediaIds.add(mediaId);
        }
        return channelIdMap;
    }

    private List<Schedule> getBlackoutSchedules(long primaryProviderId) throws EPGPluginException {
        try {
            MapSqlParameterSource parameter = new MapSqlParameterSource();
            NamedParameterJdbcTemplate template = this.getJdbcTemplate();
            String query = "SELECT provider_id, schedule_id, program_id, station_id, start_time, duration FROM Schedule where blackout='y' AND provider_id = :primaryProviderId";
            parameter.addValue("primaryProviderId", (Object)primaryProviderId);
            ArrayList<Schedule> schedules = new ArrayList<Schedule>();
            List rows = template.queryForList(query, (SqlParameterSource)parameter);
            for (Map row : rows) {
                Schedule schedule = new Schedule();
                String providerId = row.get("provider_id").toString();
                String scheduleId = row.get("schedule_id").toString();
                String programId = row.get("program_id").toString();
                String stationId = row.get("station_id").toString();
                Date startTime = BlackoutPublisher.getDateFromTimeStampWithTimeZone(row.get("start_time"));
                Long duration = new Long(row.get("duration").toString());
                schedule.setScheduleId(new SchedulePK(providerId, scheduleId));
                schedule.setProgramId(programId);
                schedule.setStationId(stationId);
                schedule.setStartTime(startTime);
                schedule.setDuration(duration);
                logger.debug("Found blackout schedule id={}, p={}, ch={}, st={}, et={}.", new Object[]{scheduleId, programId, stationId, startTime, schedule.getEndTime()});
                schedules.add(schedule);
            }
            return schedules;
        }
        catch (Exception e) {
            logger.error("getBlackoutSchedules generate exception " + e.getMessage(), (Throwable)e);
            throw new EPGPluginException((Throwable)e);
        }
    }

    private void initPrismaResources(boolean prismaInitFlag, String prismaBaseUrl) throws EPGPluginException {
        if (prismaInitFlag) {
            try {
                String audienceRoute = ESNITemplate.getResourceRoute(prismaBaseUrl, "/audience/allDevices");
                String audienceRequestBody = ESNITemplate.getAudienceRequestBody("/audience/allDevices");
                ESNIClient.Put(audienceRoute, audienceRequestBody);
                logger.info("Successfully initialized audience\n");
                this.setProgress(11);
                String viewingPolicyRoute = ESNITemplate.getResourceRoute(prismaBaseUrl, "/viewingpolicy/allDevices/blackout");
                String viewingPolicyRequestBody = ESNITemplate.getViewingPolicyRequestBody("/viewingpolicy/allDevices/blackout", "/audience/allDevices");
                ESNIClient.Put(viewingPolicyRoute, viewingPolicyRequestBody);
                logger.info("Successfully initialized viewing policy\n");
                this.setProgress(13);
                String policyRoute = ESNITemplate.getResourceRoute(prismaBaseUrl, "/policy/allDevices/blackout");
                String policyRequestBody = ESNITemplate.getPolicyRequestBody("/policy/allDevices/blackout", "/viewingpolicy/allDevices/blackout");
                ESNIClient.Put(policyRoute, policyRequestBody);
                logger.info("Successfully initialized policy\n");
            }
            catch (RequestException rex) {
                logger.error("Request exception occurred when initializing prisma resources and error is {}\n", (Object)rex.getMessage());
                throw new EPGPluginException(rex.getMessage(), (Throwable)rex);
            }
            catch (Exception ex) {
                logger.error("Exception occurred when initializing prisma resources and error is {}\n", (Object)ex.getMessage());
                throw new EPGPluginException(ex.getMessage(), (Throwable)ex);
            }
            this.setProgress(15);
        } else {
            logger.info("**Skipping prisma resources initializing as PRISMA_INIT_FLAG is set to false.**\n");
        }
    }

    private void ConfigureMediaPoints(String prismaUrl, List<Schedule> schedules, Map<String, String> mediaIdMaps, Map<String, Set<String>> channelIdMaps) throws EPGPluginException {
        Map<String, List<Schedule>> scheduleMap = this.getSchedulesPerMedia(schedules, mediaIdMaps, channelIdMaps);
        int progress = 15;
        int iterationCount = scheduleMap.size();
        int progressPerIteration = 80 / iterationCount;
        progress += 80 % iterationCount;
        RequestException requestException = null;
        String mediaResourceId = null;
        String mediaRequestBody = null;
        for (Map.Entry<String, List<Schedule>> entry : scheduleMap.entrySet()) {
            try {
                String mediaId = entry.getKey();
                String channelId = mediaIdMaps.get(mediaId);
                mediaResourceId = String.format("/media/%s", mediaId);
                String mediaRoute = ESNITemplate.getResourceRoute(prismaUrl, mediaResourceId);
                mediaRequestBody = this.buildMediaRequestBody(mediaResourceId, mediaId, channelId, entry.getValue(), "/policy/allDevices/blackout");
                ESNIClient.Put(mediaRoute, mediaRequestBody);
                logger.info("Successfully created or updated media {}\n", (Object)mediaResourceId);
                this.setProgress(progress += progressPerIteration);
            }
            catch (RequestException rex) {
                logger.error("Failed to create or update media {} having request body {}\n", mediaResourceId, mediaRequestBody);
                requestException = rex;
            }
        }
        if (requestException != null) {
            throw new EPGPluginException("Some or all media creation or updation failed. Check logs to see what went wrong", requestException);
        }
    }

    private Map<String, List<Schedule>> getSchedulesPerMedia(List<Schedule> schedules, Map<String, String> mediaIdMaps, Map<String, Set<String>> channelIdMaps) throws EPGPluginException {
        HashMap<String, List<Schedule>> scheduleMap = new HashMap<String, List<Schedule>>();
        for (String mediaId : mediaIdMaps.keySet()) {
            scheduleMap.put(mediaId, new ArrayList());
        }
        for (Schedule schedule : schedules) {
            String channelId = schedule.getStationId();
            Set<String> mediaIds = channelIdMaps.get(channelId);
            if (mediaIds == null || mediaIds.isEmpty()) {
                logger.error("Unable to convert schedule StationId (ChannelId) {} to MediaId(s)", (Object)channelId);
                throw new EPGPluginException("Unable to convert schedule  StationId (ChannelId) " + channelId + " to a MediaId");
            }
            for (String mediaId : mediaIds) {
                List mediaSchedules = (List)scheduleMap.get(mediaId);
                mediaSchedules.add(schedule);
            }
        }
        return scheduleMap;
    }

    private String buildMediaRequestBody(String mediaResourceId, String mediaId, String channelId, List<Schedule> schedules, String policyIdWithKey) {
        String lastUpdatedTime = OffsetDateTime.now(ZoneOffset.UTC).toString();
        StringBuilder mediaPoints = new StringBuilder();
        if (schedules.size() == 0) {
            mediaPoints.append(ESNITemplate.getRemoveMediaPointRequestBody(lastUpdatedTime, noBlackoutScheduleId, lastUpdatedTime, policyIdWithKey));
        } else {
            for (Schedule schedule : schedules) {
                String scheduleId = schedule.getScheduleId().getScheduleId();
                String startTime = this.Iso8601Format.format(schedule.getStartTime());
                String endTime = this.Iso8601Format.format(schedule.getEndTime());
                mediaPoints.append(ESNITemplate.getApplyMediaPointRequestBody(startTime, scheduleId, lastUpdatedTime, policyIdWithKey));
                mediaPoints.append(ESNITemplate.getRemoveMediaPointRequestBody(endTime, scheduleId, lastUpdatedTime, policyIdWithKey));
            }
        }
        return ESNITemplate.getMediaRequestBody(mediaResourceId, mediaId, lastUpdatedTime, channelId, mediaPoints);
    }

    private static Date getDateFromTimeStampWithTimeZone(Object object) {
        DateTime dateTime = new DateTime();
        dateTime = dateTime.withMillis(((Timestamp)object).getTime());
        return dateTime.toDate();
    }
}

