/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.blackout.publisher;

import com.ericsson.epgmgr.plugin.util.StringUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mediakind.neptune.common.http.CommonHttpClient;
import com.mediakind.neptune.common.http.ResponseEntity;
import com.mediakind.neptune.common.http.SSLMode;
import com.mediakind.neptune.common.http.util.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESNIClient {
    private static final Logger logger = LoggerFactory.getLogger(ESNIClient.class);
    public static final int DEFAULT_TIME_OUT = Integer.parseInt(StringUtils.isBlank((String)System.getenv("EPG_HTTP_GET_TIMEOUT")) ? "30000" : System.getenv("EPG_HTTP_GET_TIMEOUT"));
    private static CommonHttpClient httpClient = new CommonHttpClient.CommonHttpClientBuilder().connectionTimeOut(DEFAULT_TIME_OUT).socketTimeOut(DEFAULT_TIME_OUT).sslMode(SSLMode.ACCEPT_ALL).build();

    private static Map<String, String> getRequestHeader(String accept, String contentType) {
        HashMap headers = Maps.newHashMap();
        headers.put("Accept", accept);
        headers.put("Content-Type", contentType);
        return headers;
    }

    public static ResponseEntity Put(String url, String content) {
        logger.debug("Sending a PUT request using route {} and body \n{}\n", (Object)url, (Object)content);
        ResponseEntity responseEntity = httpClient.sendHttpRequest(url, (Object)content, HttpMethod.PUT, ESNIClient.getRequestHeader("application/xml", "application/xml"));
        httpClient.validateResponse(responseEntity);
        logger.info("Sending PUT request with route {} was successful with response code {}\n", (Object)url, (Object)responseEntity.getStatusCode());
        return responseEntity;
    }

    @VisibleForTesting
    static void setHttpClient(CommonHttpClient httpClient) {
        ESNIClient.httpClient = httpClient;
    }
}

