/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.blackout.publisher;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class ESNITemplate {
    public static final String AudienceId = "/audience/allDevices";
    public static final String AudienceTemplate = "<Audience match=\"ANY\" id=\"%s\" description=\"All Devices audience for blackout\" lastUpdated=\"%s\"/>";
    public static final String ViewingPolicyId = "/viewingpolicy/allDevices/blackout";
    public static final String ViewingPolicyTemplate = "<ViewingPolicy id=\"%s\" lastUpdated=\"%s\">\n    <Audience xlink:href=\"%s\"></Audience>\n    <action:Content>urn:scte:224:action:blackout</action:Content>\n</ViewingPolicy>";
    public static final String PolicyId = "/policy/allDevices/blackout";
    public static final String PolicyTemplate = "<Policy id=\"%s\" lastUpdated=\"%s\" >\n    <ViewingPolicy xlink:href=\"%s\"></ViewingPolicy>\n</Policy>";
    public static final String MediaId = "/media/%s";
    public static final String MediaTemplate = "<Media id=\"%s\" description=\"Live channel mediaId %s\" lastUpdated=\"%s\">\n    <AltID description=\"Blackout channel Id\">%s</AltID>%s\n</Media>";
    public static final String ApplyMediaPointTemplate = "\n    <MediaPoint matchTime=\"%s\" id=\"/mediapoint/scheduleId/%s/start\" lastUpdated=\"%s\">\n        <Apply>\n            <Policy xlink:href=\"%s\"></Policy>\n        </Apply>\n    </MediaPoint>";
    public static final String RemoveMediaPointTemplate = "\n    <MediaPoint matchTime=\"%s\" id=\"/mediapoint/scheduleId/%s/end\" lastUpdated=\"%s\">\n        <Remove>\n            <Policy xlink:href=\"%s\"></Policy>\n        </Remove>\n    </MediaPoint>";

    public static String getResourceRoute(String baseUrl, String resourceId) {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("baseUrl can't be null or empty");
        }
        if (resourceId == null || resourceId.trim().isEmpty()) {
            throw new IllegalArgumentException("resourceId can't be null or empty");
        }
        if (baseUrl != null && !baseUrl.trim().isEmpty() && baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + resourceId;
    }

    public static String getAudienceRequestBody(String audienceId) {
        return String.format(AudienceTemplate, audienceId, OffsetDateTime.now(ZoneOffset.UTC).toString());
    }

    public static String getViewingPolicyRequestBody(String viewingPolicyId, String audienceId) {
        return String.format(ViewingPolicyTemplate, viewingPolicyId, OffsetDateTime.now(ZoneOffset.UTC).toString(), audienceId);
    }

    public static String getPolicyRequestBody(String policyId, String viewingPolicyId) {
        return String.format(PolicyTemplate, policyId, OffsetDateTime.now(ZoneOffset.UTC).toString(), viewingPolicyId);
    }

    public static String getMediaRequestBody(String mediaResourceId, String mediaId, String lastUpdatedTime, String channelId, StringBuilder mediaPoints) {
        return String.format(MediaTemplate, mediaResourceId, mediaId, lastUpdatedTime, channelId, mediaPoints);
    }

    public static String getApplyMediaPointRequestBody(String matchTime, String scheduleId, String lastUpdatedTime, String policyId) {
        return String.format(ApplyMediaPointTemplate, matchTime, scheduleId, lastUpdatedTime, policyId);
    }

    public static String getRemoveMediaPointRequestBody(String matchTime, String scheduleId, String lastUpdatedTime, String policyId) {
        return String.format(RemoveMediaPointTemplate, matchTime, scheduleId, lastUpdatedTime, policyId);
    }
}

