#!/usr/bin/env bash

#set -ex

###################
#  Script Helper  #
###################
help_function() {
  echo "This script lists available or installed components for PrePack."
  echo "-----------------------------------------------------------------"
  echo "Usage: $0 <function>"
  echo
  echo "Available Functions:"
  echo "  -a | --available     : List all available components that can be installed for this PrePack version."
  echo "  -i | --installed     : List components that have been installed in current CMS with PrePack."
  echo "  -h | --help          : Show the help text."
  echo
  echo "Examples:"
  echo "  $0 -a"
  echo "  $0 -i"
  echo "  $0 -h"
  echo
}

# Get full path of this script file
SCRIPT=$(readlink -f "$0")
# Get folder path of this script
SCRIPT_PATH=$(dirname "$SCRIPT")
PREPACK_BIN_PATH="${SCRIPT_PATH}/prepack-bin"

############################################################
# MAIN
############################################################
if [ "$1" == "-a" ] || [ "$1" == "--available" ]; then
  python "$PREPACK_BIN_PATH"/DeployHelper.py available

elif [ "$1" == "-i" ] || [ "$1" == "--installed" ]; then
  python "$PREPACK_BIN_PATH"/DeployHelper.py installed

elif [ "$1" == "-h" ] || [ "$1" == "--help" ]; then
  help_function

else
  echo 'Invalid function detected.'
  help_function

fi
