function load_cms_charts() {
    trap 'echo "[Error] Scripts failed when running function [lib/${FUNCNAME[0]}] - error line: $LINENO, error cmd: $BASH_COMMAND"' ERR

    reset_function_timer
    cd $SCRIPTPATH
        
    beginLogging "Start preparing CMS charts."

    #### Get mdt-cli POD name
    ###get_mdt_cli_pod

    # extract CMS charts
    echo "[INFO] Preparing CMS charts..."
    mkdir -p $CHART_FOLDER
    #rm -f charts/*.tgz
    #tar -xvf $(ls -rt packages/$CMS_CHARTS_PACKAGE|tail -1) -C $CHART_FOLDER
    tar -xvf packages/cms-charts-$(ls packages/$CMS_CHARTS_PACKAGE|awk -F'-' '{print $NF}'|sort -Vr|head -1) -C $CHART_FOLDER
    
    tgz=$(find -L $CHART_FOLDER -name 'cms*.tgz')
    if [ -z "$tgz" ]; then
        echo "[ERROR] Cannot find CMS charts."
        exit 1
    else
      if [[ "$updateAPIVersion" == "true" || "$USE_SPOT_VM" == "true" ]]; then
        mkdir -p $CHART_FOLDER/temp; rm -rf $CHART_FOLDER/temp/*
        
        # Predefine the toleration for using spot vm.
        # This will be used in insert_tolerations function from common.sh.
        spot_toleration='      - key: "kubernetes.azure.com/scalesetpriority"
        operator: "Equal"
        value: "spot"
        effect: "NoSchedule"'
        echo "$spot_toleration" > $CHART_FOLDER/temp/spot_toleration.txt

        spot_toleration_cronjob='          - key: "kubernetes.azure.com/scalesetpriority"
            operator: "Equal"
            value: "spot"
            effect: "NoSchedule"'
        echo "$spot_toleration_cronjob" > $CHART_FOLDER/temp/spot_toleration_cronjob.txt

        # Can not write file into /opt/cms folder as it is no writable in cms-installer pod scenario.
        #echo "$spot_toleration" > spot_toleration.txt

        for chart in ${tgz}
        do
          (# Update apiVersion from apps/v1beta to apps/v1
            #echo "[DEBUG] Update apiVersion for chart [$chart]."
            _folder=$(basename -- ${chart} .tgz)
            mkdir -p $CHART_FOLDER/temp/$_folder
            tar -xzf $chart -C $CHART_FOLDER/temp/$_folder
            if [[ "$updateAPIVersion" == "true" ]]; then
              sed -i 's/apiVersion: apps\/v1.*/apiVersion: apps\/v1/' $CHART_FOLDER/temp/$_folder/*/templates/*.yaml
              sed -i 's/apiVersion: rbac.authorization.k8s.io\/v1.*/apiVersion: rbac.authorization.k8s.io\/v1/' $CHART_FOLDER/temp/$_folder/*/templates/*.yaml
            fi
            if $USE_SPOT_VM ; then
              export INSERT_SPOT_TOLERATIONS=true
            fi
            if $USE_SPOT_VM ; then
            #if $USE_SPOT_VM || $USE_XXX; then
              insert_tolerations "$CHART_FOLDER/temp/$_folder"
            fi
            # rename the label key app to cmsapp
            #sed -i 's/ app: / cmsapp: /' $CHART_FOLDER/temp/$_folder/*/templates/*.yaml
            #echo "[Debug] All apiVersion values."
            #grep apiVersion $CHART_FOLDER/temp/$_folder/*/templates/*.yaml
            #echo "[Debug] =====================."
            cd $CHART_FOLDER/temp/$_folder; helm package * > /dev/null; mv -f *.tgz ../..
            cd - > /dev/null
            rm -rf $CHART_FOLDER/temp/$_folder
          )&
        done
      fi
    fi
    
    wait

    running_time

    ########################################################
    ## For Test Only!!!!
    ## Remove once test done!!!
    #echo "[TEST-ONLY] Force exit from load_cms_charts !!!"
    #exit 1
    ########################################################

}
