#!/usr/bin/env bash

#set -ex
#set -x
#set -e


product_var_fie=$1

# Get full path of this script file
SCRIPT=$(readlink -f "$0")
# Get folder path of this script
SCRIPTPATH=$(dirname "$SCRIPT")
PARENTPATH=$(dirname "$SCRIPTPATH")

BUNDLEFOLDER="${PARENTPATH}/ConfigBundle"

if [[ -z "$product_var_fie" ]]; then
  PRODUCTSVAR_FILE="${BUNDLEFOLDER}/products-var.yaml"
else
  PRODUCTSVAR_FILE="$product_var_fie"
fi

PRODUCTSVAR_FILE_NAME=$(basename $PRODUCTSVAR_FILE)
RESULT_FILE="$SCRIPTPATH/resource-$PRODUCTSVAR_FILE_NAME.csv"

function to_m() {
    # switch cpu to unit m
    local input=$1
    if [[ -n $input ]]; then
      # pure number to unit m
      if [[ -z "${input//[0-9]/}" ]]; then
        value=$(($input * 1000))
      else
        num=${input%%m*}
        value=$num
      fi
      echo -n $value
    else
      echo 0
    fi
}

function to_Mi() {
    # switch memory to unit Mi
    local input=$1
    if [[ -n $input ]]; then
      if [[ "$input" =~ "Gi" ]]; then
        num=${input%%G*}
        value=$(($num * 1024))
      else
        num=${input%%M*}
        value=$num
      fi
      echo -n $value
    else
      echo 0
    fi
}

function get_parent_field() {
    # switch memory to unit Mi
    local input=$1
    field=${input%%:*}
    key=${field##*.}
    echo ${field}|sed -e "s/.$key//"
    #echo $key
}

function get_value() {
    local input=$1
    if [ -n $input ]; then
      echo ${input##*:}|sed -e 's/"//g'
    else
      echo 0
    fi
}

# Test
#to_m $1
#to_Mi $2
##REPLICAS_INFO=$(yq r -p pv /opt/cms/ConfigBundle/products-var.yaml.sample.enterprise '**.replicaCount'|sed -e s'/ //g')
##CPULIMIT_INFO=$(yq r -p pv /opt/cms/ConfigBundle/products-var.yaml.sample.enterprise '**.cpuLimits'|sed -e s'/ //g')
#REPLICAS_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.replicaCount'|sed -e s'/ //g')
#CPULIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.cpuLimits'|sed -e s'/ //g')
#CPUREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.cpuRequests'|sed -e s'/ //g')
#MEMLIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.memoryLimits'|sed -e s'/ //g')
#MEMREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.memoryRequests'|sed -e s'/ //g')

#For Elasticsearch
#ES_MASTER_REPLICAS_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.masterReplicaCount'|sed -e s'/ //g')
#ES_MASTER_CPULIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.masterCpuLimits'|sed -e s'/ //g')
#ES_MASTER_CPUREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.masterCpuRequests'|sed -e s'/ //g')
#ES_MASTER_MEMLIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.masterMemoryLimits'|sed -e s'/ //g')
#ES_MASTER_MEMREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.masterMemoryRequests'|sed -e s'/ //g')
#ES_DATA_REPLICAS_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.dataReplicaCount'|sed -e s'/ //g')
#ES_DATA_CPULIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.dataCpuLimits'|sed -e s'/ //g')
#ES_DATA_CPUREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.dataCpuRequests'|sed -e s'/ //g')
#ES_DATA_MEMLIMIT_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.dataMemoryLimits'|sed -e s'/ //g')
#ES_DATA_MEMREQ_INFO=$(yq r -p pv $PRODUCTSVAR_FILE '**.dataMemoryRequests'|sed -e s'/ //g')

#change to yq4
REPLICAS_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep replicaCount|sed -e s'/ //g')
CPULIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep cpuLimits|sed -e s'/ //g')
CPUREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep cpuRequests|sed -e s'/ //g')
MEMLIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep memoryLimits|sed -e s'/ //g')
MEMREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep memoryRequests|sed -e s'/ //g')

#For Elasticsearch
ES_MASTER_REPLICAS_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep masterReplicaCount|sed -e s'/ //g')
ES_MASTER_CPULIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep masterCpuLimits|sed -e s'/ //g')
ES_MASTER_CPUREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep masterCpuRequests|sed -e s'/ //g')
ES_MASTER_MEMLIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep masterMemoryLimits|sed -e s'/ //g')
ES_MASTER_MEMREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep masterMemoryRequests|sed -e s'/ //g')
ES_DATA_REPLICAS_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep dataReplicaCount|sed -e s'/ //g')
ES_DATA_CPULIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep dataCpuLimits|sed -e s'/ //g')
ES_DATA_CPUREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep dataCpuRequests|sed -e s'/ //g')
ES_DATA_MEMLIMIT_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep dataMemoryLimits|sed -e s'/ //g')
ES_DATA_MEMREQ_INFO=$(yq e '.. | select(. == "*") | {(path | join(".")): .}' $PRODUCTSVAR_FILE |grep dataMemoryRequests|sed -e s'/ //g')


> $RESULT_FILE
echo 'COMPONENT,REPLICA,CPULIMIT(m),MEMLIMIT(Mi),CPUREQ,MEMREQ,TOTAL_CPULIMIT,TOTAL_MEMLIMIT,TOTAL_CPUREQ,TOTAL_MEMREQ' |& tee -i -a $RESULT_FILE

for item in $REPLICAS_INFO;
do
  #echo $item
  _name=$(get_parent_field $item)
  _replica=$(get_value $item)
  _cpulimit=$(to_m $(get_value $(echo "$CPULIMIT_INFO"|grep "^$_name")))
  _memlimit=$(to_Mi $(get_value $(echo "$MEMLIMIT_INFO"|grep "^$_name")))
  _cpureq=$(to_m $(get_value $(echo "$CPUREQ_INFO"|grep "^$_name")))
  _memreq=$(to_Mi $(get_value $(echo "$MEMREQ_INFO"|grep "^$_name")))
  t_cpulimit=$(($_replica * $_cpulimit))
  t_memlimit=$(($_replica * $_memlimit))
  t_cpureq=$(($_replica * $_cpureq))
  t_memreq=$(($_replica * $_memreq))

  echo "$_name,$_replica,$_cpulimit,$_memlimit,$_cpureq,$_memreq,$t_cpulimit,$t_memlimit,$t_cpureq,$t_memreq" |& tee -i -a $RESULT_FILE

done

for item in $ES_MASTER_REPLICAS_INFO;
do
  #echo $item
  _name=$(get_parent_field $item)
  _replica=$(get_value $item)
  _cpulimit=$(to_m $(get_value $(echo "$ES_MASTER_CPULIMIT_INFO"|grep "^$_name")))
  _memlimit=$(to_Mi $(get_value $(echo "$ES_MASTER_MEMLIMIT_INFO"|grep "^$_name")))
  _cpureq=$(to_m $(get_value $(echo "$ES_MASTER_CPUREQ_INFO"|grep "^$_name")))
  _memreq=$(to_Mi $(get_value $(echo "$ES_MASTER_MEMREQ_INFO"|grep "^$_name")))
  t_cpulimit=$(($_replica * $_cpulimit))
  t_memlimit=$(($_replica * $_memlimit))
  t_cpureq=$(($_replica * $_cpureq))
  t_memreq=$(($_replica * $_memreq))

  echo "${_name}Master,$_replica,$_cpulimit,$_memlimit,$_cpureq,$_memreq,$t_cpulimit,$t_memlimit,$t_cpureq,$t_memreq" |& tee -i -a $RESULT_FILE

done

for item in $ES_DATA_REPLICAS_INFO;
do
  #echo $item
  _name=$(get_parent_field $item)
  _replica=$(get_value $item)
  _cpulimit=$(to_m $(get_value $(echo "$ES_DATA_CPULIMIT_INFO"|grep "^$_name")))
  _memlimit=$(to_Mi $(get_value $(echo "$ES_DATA_MEMLIMIT_INFO"|grep "^$_name")))
  _cpureq=$(to_m $(get_value $(echo "$ES_DATA_CPUREQ_INFO"|grep "^$_name")))
  _memreq=$(to_Mi $(get_value $(echo "$ES_DATA_MEMREQ_INFO"|grep "^$_name")))
  t_cpulimit=$(($_replica * $_cpulimit))
  t_memlimit=$(($_replica * $_memlimit))
  t_cpureq=$(($_replica * $_cpureq))
  t_memreq=$(($_replica * $_memreq))

  echo "${_name}Data,$_replica,$_cpulimit,$_memlimit,$_cpureq,$_memreq,$t_cpulimit,$t_memlimit,$t_cpureq,$t_memreq" |& tee -i -a $RESULT_FILE

done

Total_cpu_limit=$(cat $RESULT_FILE|awk -F ',' '{sum+=$7} END {print sum}')
Total_mem_limit=$(cat $RESULT_FILE|awk -F ',' '{sum+=$8} END {print sum}')
Total_cpu_req=$(cat $RESULT_FILE|awk -F ',' '{sum+=$9} END {print sum}')
Total_mem_req=$(cat $RESULT_FILE|awk -F ',' '{sum+=$10} END {print sum}')

echo "TOTAL,-,-,-,-,-,${Total_cpu_limit}m,${Total_mem_limit}Mi,${Total_cpu_req}m,${Total_mem_req}Mi" |& tee -i -a $RESULT_FILE
