#!/bin/bash

###############################################
##  script       : shutdown_vm.sh          ####
##  usage        : ./shutdown_vm.sh        ####
##  description  : To stop services and    ####
##                 shutdown VMs            ####
###############################################


function disable_shards () {
    #Disabling shard allocation and performing synced flush on Elasticsearch clusters
    echo -e "Disabling shard allocation and performing synced flush on CS Elasticsearch cluster.....\n"
    curl -XPUT 'app:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'app:9200/_flush/synced' -s -m 60 2> /dev/null
    echo

    echo -e "Disabling shard allocation and performing synced flush on ES Elasticsearch cluster.....\n"
    curl -XPUT 'es:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'es:9200/_flush/synced' -s -m 60 2> /dev/null
    echo
}

sudo su -c "service cms-cluster stop" $(whoami)

disable_shards

Services="consul-template haproxy keepalived crond consul"
for service in $Services; do
    sudo su -c "service cms-cluster stop -s $service" $(whoami)
done

nodes="pt1 app1 es1 edb1 cs1"
for node in $nodes; do
	cd /mnt/backup/
	if name=$(ssh -o StrictHostKeyChecking=no root@$node "hostname -s"); then
		file="$(ls -tr /mnt/backup/ | grep "$name" | tail -n1)"
	    if [[ ! -z "$file" ]]; then
	        sudo /usr/bin/cp -f "$file" /mnt/backup/$node.tgz
	    else
	        echo "WARNING: No backup file found for $node" 
	    fi
	else
	    echo "WARNING: Could not connect to $node."
    fi
    sudo su -c "service cms-cluster shutdown -n $node" $(whoami)
done
