#!/bin/bash

###############################################
##  script       : shutdown.sh             ####
##  usage        : ./shutdown.sh           ####
##  description  : To stop services and    ####
##                 shutdown VMs            ####
##  version      : 7.0.12                 ####
###############################################


function disable_shards () {
    #Disabling shard allocation and performing synced flush on Elasticsearch clusters
    echo -e "Disabling shard allocation and performing synced flush on CS Elasticsearch cluster.....\n"
    curl -XPUT 'app:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'app:9200/_flush/synced' -s -m 60 2> /dev/null
    echo

    echo -e "Disabling shard allocation and performing synced flush on ES Elasticsearch cluster.....\n"
    curl -XPUT 'es:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'es:9200/_flush/synced' -s -m 60 2> /dev/null
    echo
}

sudo su -c "service cms-cluster stop" $(whoami)

disable_shards

Services="consul-template haproxy keepalived crond consul"
for service in $Services; do
    sudo su -c "service cms-cluster stop -s $service" $(whoami)
done

time='0'
ppfm_time='0'
edb1_status=$(ssh -o StrictHostKeyChecking=no root@edb1 "status=\$(su - edb -c 'PGPASSWORD=n2bbsys psql -d ttv -U edb -q -t -c \"select pg_is_in_recovery();\"'); echo \$status")
edb2_status=$(ssh -o StrictHostKeyChecking=no root@edb2 "status=\$(su - edb -c 'PGPASSWORD=n2bbsys psql -d ttv -U edb -q -t -c \"select pg_is_in_recovery();\"'); echo \$status")
if [ "$edb1_status" == "f" ]; then
    echo "EDB1 is current database master. Failing over to make EDB2 master."
    while ! $(ssh -o StrictHostKeyChecking=no root@edb2 "service ppfm-1.1 cluster-status | tail -n1 | grep 'It is safe to promote' &> /dev/null"); do
        echo "Waited $ppfm_time seconds for master and standby database to be up to date. Will retry in 10 seconds."
        sleep 10
        ppfm_time=$((ppfm_time+10))
    done
    ssh -o StrictHostKeyChecking=no root@edb1 "service ppas-9.3 stop"
    while [ "$edb2_status" != "f" ]; do
        echo "Waited $time seconds for EDB2 to become database master. Will retry in 10 seconds."
        sleep 10
        time=$((time+10))
        edb2_status=$(ssh -o StrictHostKeyChecking=no root@edb2 "status=\$(su - edb -c 'PGPASSWORD=n2bbsys psql -d ttv -U edb -q -t -c \"select pg_is_in_recovery();\"'); echo \$status")
    done
elif [ "$edb2_status" == "f" ]; then
    echo "EDB2 is master database. Proceeding for next steps."
else
    echo "ERROR: Unable to find master databse node. Exiting."
    exit 1
fi

prompt=''
echo "Pre-requisites for breaking down cluster is done. EDB2 is master database. Proceeding further."
if [ -z "$1" ] || [ "$1" != "f" ]; then
    echo -n 'Do you wish to proceed to next step and start breaking down cluster [y/n]?   '
    read prompt
    while [ "$prompt" != 'y' ]; do
        if [ "$prompt" == 'n' ]; then
            echo "INFO: '$prompt' is entered. Exiting cluster breakdown process."
            exit 1
        else
            echo -n 'Do you wish to proceed to next step and start breaking down cluster [y/n]?   '
            read prompt
        fi
    done
fi

echo "Received acknowledgement to proceed with cluster breakdown. Proceeding."

nodes="pt1 app1 es1 edb1 cs1"
for node in $nodes; do
	cd /mnt/backup/
	if name=$(ssh -o StrictHostKeyChecking=no root@$node "hostname -s"); then
		file="$(ls -tr /mnt/backup/ | grep "$name" | tail -n1)"
	    if [[ ! -z "$file" ]]; then
	        sudo /bin/cp -f "$file" /mnt/backup/$node.tgz
	    else
	        echo "WARNING: No backup file found for $node" 
	    fi
	else
	    echo "WARNING: Could not connect to $node."
    fi
    sudo su -c "service cms-cluster shutdown -n $node" $(whoami)
done