#!/bin/bash
# setupNFSServer.sh - install the tools and setup this system as an NFS server
#   setupNFSServer.sh  <folderToShare>

# install the client/server
yum install nfs-utils nfs-utils-lib -q -y

# set to start
chkconfig --levels 235 nfs on
chkconfig --levels 235 rpcbind on

# start services
service rpcbind start
service nfs start

# create share
echo "$1	*(rw,sync,no_root_squash,no_subtree_check)" >> /etc/exports

# share it
exportfs -a
