#!/bin/bash

###############################################
##  script       : shutdown_vm.sh          ####
##  usage        : ./shutdown_vm.sh        ####
##  description  : To stop services and    ####
##                 shutdown VMs            ####
###############################################


function disable_shards () {
    #Disabling shard allocation and performing synced flush on Elasticsearch clusters
    echo -e "Disabling shard allocation and performing synced flush on CS Elasticsearch cluster.....\n"
    curl -XPUT 'app:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'app:9200/_flush/synced' -s -m 60 2> /dev/null
    echo

    echo -e "Disabling shard allocation and performing synced flush on ES Elasticsearch cluster.....\n"
    curl -XPUT 'es:9200/_cluster/settings' -d'{"persistent": {"cluster.routing.allocation.enable": "none"}}' -s
    echo
    curl -XPOST 'es:9200/_flush/synced' -s -m 60 2> /dev/null
    echo
}

sudo su -c "service cms-cluster stop" $(whoami)
Services="consul-template haproxy keepalived crond consul"
for service in $Services; do
    sudo su -c "service cms-cluster stop -s $service" $(whoami)
done

disable_shards

nodes="pt1 app1 es1 edb1 cs1"
for node in $nodes; do
    service cms-cluster shutdown -n $node
done

