# CMS Configuration config.json files
resource "template_dir" "config" {
    source_dir = "${path.module}/../config_templates"
    destination_dir = "${path.cwd}/config"

    vars = {
        customerLicenseId = "${var.cms_license_fingerprint}"
        privateNetmask = "${cidrnetmask(var.cms_private_cidr)}"
        # use azure internal DNS
        vpc_dns = "${var.azure_dns}"
        consul_servers = "${var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\"" }"
        named_master = "${element(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 0)}"
        named_slaves = "${jsonencode(slice(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 1, length(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses))))}"
#        cms_nas_server = "${aws_efs_file_system.cms.dns_name}"
        cms_nas_server = "${element(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 0)}"
#        content_nas_server = "${aws_efs_file_system.content.dns_name}"
        content_nas_server = "${element(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 0)}"
        mountOptions = "${join(",", var.mount_options)}"
        remount = "${var.remount}"
        privateDomain = "${var.cms_dns_domain}"
##TODO - add load balancer when done (using )
#        ui_eip = "${aws_lb.ui_vip.dns_name}"
#        ui_eip = "${element(flatten(azurerm_public_ip.cs_public_ip.*.ip_address), 0)}"
         ui_eip = "${element(flatten(azurerm_public_ip.cs_public_ip.*.fqdn), 0)}"
#        app_eip = "${aws_lb.internal_vip.dns_name}"
        app_eip = "${element(flatten(azurerm_network_interface.cs_nic.*.private_ip_addresses), 0)}"
        timezone = "${var.timezone}"
        dbserver = "${azurerm_postgresql_server.edb1.fqdn}"
        snmpServer = "${var.snmp_server}"
        privateNetwork = "${cidrhost(var.cms_private_cidr,0)}"
        customerInstanceId = "${var.customerInstanceId}"
        installName = "${var.install_name}"
    }
}
