resource "azurerm_postgresql_server" "edb1" {
  name                  = "edb1"
  location              = "${azurerm_resource_group.cms-rg.location}"
  resource_group_name   = "${azurerm_resource_group.cms-rg.name}"

  sku {
    name     = "B_Gen5_2"
    capacity = 2
    tier     = "Basic"
    family   = "Gen5"
  }

  storage_profile {
    storage_mb            = 262144
    backup_retention_days = 7
    geo_redundant_backup  = "Disabled"
  }

  administrator_login          = "postgres"
  administrator_login_password = "${var.rds_db_pass}"
  version                      = "${var.rds_db_version}"
  ssl_enforcement              = "Disabled"
}

resource "azurerm_sql_firewall_rule" "access_azure_db" {
  name                = "access_azure_db"
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
  server_name         = "${azurerm_postgresql_server.edb1.name}"
  start_ip_address    = "0.0.0.0"
  end_ip_address      = "0.0.0.0"
}