resource "azurerm_storage_account" "storageaccount" {
  name                     = "${var.install_name}storageac"
  resource_group_name      = "${azurerm_resource_group.cms-rg.name}"
  location                 = "${azurerm_resource_group.cms-rg.location}"
  account_tier             = "${var.account_tier}"
  account_replication_type = "${var.account_replication_type}"
  #enable_file_encryption   = "false"

 #network_rules {
 #  #ip_rules                   = ["${var.storage_bastion_ip}"]
 #  ip_rules                   = "${var.bastion_public_cidr}"
 #  virtual_network_subnet_ids = ["${azurerm_subnet.cms-subnet.id}"]
 #}
 
  tags = {
    environment = "${var.tag_environment}"
  }
}

resource "azurerm_storage_share" "appshare" {
  name = "appshare-${var.install_name}"

  resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"

  quota = "${var.storage_share_quota}"
}
resource "azurerm_storage_share" "backupshare" {
  name = "backupshare-${var.install_name}"

  resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"

  quota = "${var.storage_share_quota}"
}
resource "azurerm_storage_share" "contentshare" {
  name = "contentshare-${var.install_name}"

  resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"

  quota = "${var.storage_share_quota}"
}

resource "azurerm_storage_share" "ctcontentshare" {
  name = "ctcontentshare-${var.install_name}"
  count ="${(!var.cloud_ext_ct ? 1: 0) * (var.ct_count == 0 ? 0 : 1)}"

  resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
  storage_account_name = "${azurerm_storage_account.storageaccount.name}"

  quota = "${var.storage_share_quota}"
}


output "appshare" {
    value = "${azurerm_storage_share.appshare.url}"
    #value = "${replace(azurerm_storage_share.appshare.url, "https:", "")}"
}
output "contentshare" {
    value = "${azurerm_storage_share.contentshare.url}"
}
output "backupshare" {
    value = "${azurerm_storage_share.backupshare.url}"
}

output "storageaccount_name" {
    value = "${azurerm_storage_account.storageaccount.name}"
}
output "storageaccount_accesskey" {
    value = "${azurerm_storage_account.storageaccount.primary_access_key}"
}