#!/bin/bash
# waitForClusterServer.sh  - utility to download cms-node-config.tgz  cms-node-config.json file it has been downloaded.
# waitForClusterServer.sh  <url-to-indicate-clusterServer-Ready>
#
# Chris Bentz - May 2017
if [ -z "$1" ]; then
	echo "Usage: $0 <url-to-clusterServer-Ready-file>"
	exit 1
fi

# wait for the cluster server to indicate its complete.
response=$(curl --write-out %{http_code} --silent --HEAD --output /dev/null $1)
while [ $response -ne 200 ]
do
echo Waiting for Cluster Server..
sleep 5
response=$(curl --write-out %{http_code} --silent --HEAD --output /dev/null $1)
done
echo Cluster Server Ready!
