
# Installation Identifier - every concurrent deployment needs a unique install name
variable "install_name" {
    description = "Textual Name of this CMS Install"
}

variable "tag_environment" {
    description = "Environment tag, Staging or Production."
    default = "Staging"
}

# Azure Details - where and how to create the install
variable "azure_region" {
    description = "Azure region to launch vms into"
    default = "us-west-2"
}

variable "subscription_id" {
    description = "Resources will be created under this subscription"
}

variable "tenant_id" {
    description = "Resources will be created under this tenant"
}

variable "client_id" {
    description = "Client ID used for Azure RM API access"
}

variable "client_secret" {
    description = "Client Secret used for Azure RM API access"
}

variable "app_count" {
    description = "number of application nodes to deploy"
    default = "1"
}

variable "cs_count" {
    description = "number of Cluster Service nodes to deploy"
    default = "1"
}

variable "es_count" {
    description = "number of ElasticSearch nodes to deploy"
    default = "1"
}

variable "pt_count" {
    description = "number of Portal nodes to deploy"
    default = "0"
}

variable "ct_count" {
    description = "number of Content nodes to deploy"
    default = "0"
}

variable "rds_multi_az" {
    description = "true to deploy database with high availability"
    default = false
}

variable "az_count" {
    description = "number of availability zones to spread across"
    default = 3
}

variable "dev_mode" {
    description = "True to run in development mode (smaller/cheaper instance types, output nodes to file for automated tests)"
    default = true
}

variable "mount_options" {
    description = "mount options for EFS"
    default = ["nolock","nfsvers=4.1"]
}

variable "remount" {
    description = "enable/disable remount as a mount option; should remain false for EFS"
    default = false
}

# Security Firewall configuration

variable "admin_whitelist" {
    description = "networks to allow admin connectivity from"
    default = []
}

# must match the company NAT rules in use to allow access to the install from the company network
variable "external_whitelist" {
    description = "networks to allow external connectivity from - replace with corporate public IP address range from corporate Nat/gateway; limit to 5"
    default = []
}

variable "bastion_public_cidr" {
    description = "the public IP cidr of the bastion system, used to kickstart the deployment.  This IP must be allowed in the security groups.  i.e.   dig +short myip.opendns.com @resolver1.opendns.com"
    default = []
}

variable "ui_ports" {
    description = "Accessible CMS UI ports"
    default = ["21","80","8081","8443","8501","9292","9393","16443"]
}

variable "internal_lb_ports" {
    description = "Internal CMS load balanced ports"
    default = ["5000","6003","7070","7443","8080","8444"]
}

variable "cs_ports" {
    description = "Accessible CMS ports for CS nodes"
    default = ["5601","9090","9200"]
}

# Networking Defaults
variable "aws_vpc_cidr" {
    description = "The CIDR of the VPC to create."
    default = "10.0.0.0/16"
}

variable "cms_private_cidr" {
    description = "The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
    default = "10.0.0.0/24"
}

variable "rds_subnet_cidr" {
    description = "The CIDR of the Subnet to create with the VPC for RDS instances. Must be a valid subnet of the VPC cidr."
    default = "10.0.1.0/24"
}


# Instance Type selection for the vms
variable "aws_instance_type_nfs" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_nfs_dev" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances in development mode"
    default = "Standard_E2_v3"
}

variable "aws_instance_type_cs" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_cs_dev" {
    description = "The AWS Instance Type to use for CMS Cluster Server Instances in development mode"
    default = "Standard_E2_v3"
}

variable "aws_instance_type_app" {
    description = "The AWS Instance Type to use for CMS Application Server Instances."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_app_dev" {
    description = "The AWS Instance Type to use for CMS Application Server Instances in development mode"
    default = "Standard_E2_v3"
}

variable "aws_instance_type_rds" {
    description = "The AWS Instance Type to use for AWS PostgreSQL RDS Instances."
    default = "db.m4.4xlarge"
}

variable "aws_instance_type_rds_dev" {
    description = "The AWS Instance Type to use for AWS PostgreSQL RDS Instances in development mode"
    default = "db.m4.large"
}

variable "aws_instance_type_es" {
    description = "The AWS Instance Type to use for CMS Elastic Search Server Instances. "
    default = "Standard_E2_v3"
}

variable "aws_instance_type_es_dev" {
    description = "The AWS Instance Type to use for CMS Elastic Search Server Instances in development mode"
    default = "Standard_E2_v3"
}


variable "aws_instance_type_pt" {
    description = "The AWS Instance Type to use for CMS Portal Server Instances.   Install will fail if this value is lowered."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_pt_dev" {
    description = "The AWS Instance Type to use for CMS Portal Server Instances.   Install will fail if this value is lowered."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_ct" {
    description = "The AWS Instance Type to use for CMS Content Server Instances."
    default = "Standard_E2_v3"
}

variable "aws_instance_type_ct_dev" {
    description = "The AWS Instance Type to use for CMS Content Server Instances in development mode"
    default = "Standard_E2_v3"
}


# Instance Volume Type
# select one of standard, gp2 or io1
#  standard = magnetic
#  gp2 = General Provision SSD
#  io1 = Provisioned IOPS SSD

variable "root_volume_type" {
    description = "Volume type to use on boot/root disk"
    default = "Standard_LRS"
}

variable "block_volume_type" {
    description = "Volume type to use on additional file system space"
    default = "Standard_LRS"
}

variable "delete_disks_on_termination" {
    description = "Should the disks (OS and data) be deleted when the VM is destroyed? "
    default = "true"
}

# Instance Disk Space expansion
# amount of additional disk space to alloate to each instances

variable "instance_block_size_cs" {
    description = "Number of GB of additional space to alloate to Cluster Server instances"
    default = "20"
}

variable "instance_block_size_app" {
    description = "Number of GB of additional space to alloate to Application Server instances"
    default = "30"
}

variable "instance_block_size_es" {
    description = "Number of GB of additional space to alloate to Elastic Search Server instances"
    default = "20"
}

variable "instance_block_size_pt" {
    description = "Number of GB of additional space to alloate to Portal Server instances"
    default = "20"
}

variable "instance_block_size_ct" {
    description = "Number of GB of additional space to alloate to Content Server instances"
    default = "20"
}

# NAS Backing Block Details

variable "content_nas_volume_size" {
    description = "Number of GB to allocate for contenet share"
    default = "100"
}

variable "content_nas_volume_type" {
    description = "Type of aws block device to allocate for content share"
    default = "standard"
}


####Standalone NFS VM
variable "instance_block_size_nfs" {
    description = "Number of GB of additional space to alloate to Portal Server instances"
    default = "120"
}

variable "delete_nfs_disks_on_termination" {
    description = "Should the disks (OS and data) be deleted when the VM is destroyed? "
    default = "true"
}


# Location of installation media

variable "cms_softwareonly_s3_bucket_url" {
    description = "AWS URL to the s3 bucket containing the CMS softwareOnly rpm to intall"
    default = ""
}

variable "cms_prepack_release" {
    description = "The PrePack installation tar file - should be avaiable at the var.cms_softwareonly_s3_bucket_url "
    default = "prepack-aio-master-SNAPSHOT.3398.tar.gz"
}

variable "cms_prepack_component_selection" {
    description = "Filename of CMS PrePack component selection json file"
    default = "prepack-component-selections.json"
}

variable "cms_prepack_component_response" {
    description = "Character input pattern to use during install of prepack deploy.sh - for install with no prompts."
    default = <<EOV
4
yes
yes

EOV
}

variable "cms_prepack_patch" {
    description = "The PrePack installation patch file - should be avaiable at the var.cms_softwareonly_s3_bucket_url "
    default = ""
}

# CMS License & Fingerprint

variable "cms_license_fingerprint" {
    description = "CMS Installation License Fingerprint - do not change"
    default = "00000000000000000000000000000000"
}

variable "customerInstanceId" {
    description = "A value used internally - mostly here for legacy purposes"
    default = "cms"
}

variable "license_file_path" {
    description = "Path to CMS license file - do not change"
    default = "../license.xml"
}

variable "prepack_license_file_path" {
    description = "Path to CMS prepack license file - do not change"
    default = "../prepackLicense.xml"
}

# Instance Hostname/domain details

variable "cms_hostname_cs" {
    description = "The hostname prefix for the Cluster Server Instance"
    default = "cms-cs"
}

variable "cms_hostname_app" {
    description = "The hostname prefix for the Application Server Instance"
    default = "cms-app"
}

variable "cms_hostname_es" {
    description = "The hostname prefix for the Elastic Search Server Instance"
    default = "cms-es"
}

variable "cms_hostname_pt" {
    description = "The hostname prefix for the Portal Server Instance"
    default = "cms-pt"
}

variable "cms_hostname_ct" {
    description = "The hostname prefix for the Content Server Instance"
    default = "cms-pt"
}

variable "cms_dns_domain" {
    description = "Network Domain name for CMS Instances"
    default = "ericsson.local"
}

variable "timezone" {
    description = "Timezone to run the Instances in..."
    default = "America/Los_Angeles"
}

variable "ntp1" {
    description = "First ntp server ip"
    default = "0.rhel.pool.ntp.org"
}

variable "ntp2" {
    description = "Second ntp server ip"
    default = "1.rhel.pool.ntp.org"
}

variable "snmp_server" {
    description = "SNMP server"
    default = "127.0.0.1"
}

# Configuration template
variable "config_json_template" {
    description = "Path to CMS Configuration file template - do not change"
    default = "./software1nonHA.tpl"
}

variable "config_install_sysInfo_template" {
    description = "PrePack install sysInfo file"
    default = "./prepackTools/install_sysInfo_1NonHA.tpl"
}

# Base Operation System image to install - add more regions as needed...
variable "aws_ami_product_code" {
    description = "AMI product code identifiers to use in various regions - should be CentOS 7"
    default = "aw0evgkw8e5c1q413zgy5pjce" # CentOS 7 (x86_64) - with Updates HVM
}

# SSH Key Details
# this allows ssh into the instances via keys on the bastion system.

variable "private_key_path" {
    description = "The path of the ssh private key the bastion will use to configure instances"
    default = "~/.ssh/cms_terraform_id_rsa"
}

variable "public_key_path" {
    description = "The path of the ssh pub key the bastion will use to configure instances"
    default = "~/.ssh/cms_terraform_id_rsa.pub"
}

variable "ssh_user" {
    description = "user to ssh as"
    default = "centos"
}

variable "ssh_user_password" {
    description = "Password set when creating ssh_user, but password based ssh is disabled by default "
    default = "CmsOnAzureAdm1n!"
}

variable "rds_db_version" {
    description = "Use this to set the db version for RDS instance creation."
    default = "9.5"
}

variable "rds_db_minor_version" {
    description = "Use this to set the db version for RDS instance creation."
    default = "12"
}

variable "rds_db_name" {
    description = "Use this to set the db name for RDS instance creation."
    default = "ttv"
}

variable "rds_db_port" {
    description = "Use this to set the db port for RDS instance creation."
    default = "5432"
}

variable "rds_db_user" {
    description = "Use this to set the db user for RDS instance creation."
    default = "postgres"
}

variable "rds_db_pass" {
    description = "Use this to set the db password for RDS instance creation."
    default = "CmsAzureDbAdm1n!"
}

variable "package_location" {
    description = "Location of CMS packages to install"
    default = "../packages"
}


###############   Azure Variables ###################

###Azure OS references###

variable "os_publisher" {
    description = "Publisher property for OS Image Reference"
    default = "OpenLogic"
}

variable "os_offer" {
    description = "Offer property for OS Image Reference"
    default = "CentOS"
}

variable "os_sku" {
    description = "Sku property for OS Image Reference"
    default = "7.6"
}

variable "os_version" {
    description = "Version property for OS Image Reference"
    default = "latest"
}

variable "azure_dns" {
    description = "Azure DNS to use as forwarder"
    default = "168.63.129.16"
}

###Azure Storage File Share references###
variable "account_tier" {
    description = "(Required) Defines the Tier to use for this storage account. Valid options are Standard and Premium. Changing this forces a new resource to be created."
    default = "Standard"
}

variable "account_replication_type" {
    description = "(Required) Defines the type of replication to use for this storage account. Valid options are LRS, GRS, RAGRS and ZRS."
    default = "LRS"
}


variable "storage_share_quota" {
    description = "(Optional) The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5 TB (5120 GB). Default is 5120."
    default = "75"
}

#variable "storage_bastion_ip" {
#    description = "(Optional) List of public IP or IP ranges in CIDR Format. Only IPV4 addresses are allowed. Private IP address ranges (as defined in RFC 1918) are not allowed."
#    default = "119.35.92.203"
#}

####CT nodes installation
variable "cloud_ext_ct" {
    description =  "To determine whether CT nodes need to be installed inside or outside aws."
    default = false
}

###Availability Set
variable "platform_fault_domain_count" {
    description =  "To determine the platform fault domain count, Default 3"
    default = "3"
}
variable "platform_update_domain_count" {
    description =  "To determine the platform update domain count, Default 3"
    default = "3"
}
