# this file manages the networks created as part of the deployment
# VM Specific networking is managed in vm.tf and tied to the VMs being created


# Create virtual network
resource "azurerm_virtual_network" "cms-network" {
    name                = "azure_VPC_cidr"
    address_space       = ["${var.vnet_cidr}"]
    location            = "${var.azure_region}"
    resource_group_name = "${azurerm_resource_group.cms-rg.name}"

    tags = {
        environment = "${var.tag_environment}"
    }
}

# Create subnet
resource "azurerm_subnet" "cms-subnet" {
    name                 = "azure_subnet_cidr"
    resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
    virtual_network_name = "${azurerm_virtual_network.cms-network.name}"
    address_prefix       = "${var.cms_private_cidr}"
    service_endpoints    = ["Microsoft.Storage","Microsoft.Sql"]
}

## Create subnet
#resource "azurerm_subnet" "sql-subnet" {
#    name                 = "azure_subnet_sql"
#    resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
#    virtual_network_name = "${azurerm_virtual_network.cms-network.name}"
#    address_prefix       = "10.0.1.0/24"
#}

#resource "azurerm_subnet" "storage-subnet" {
#    name                 = "azure_subnet_storage"
#    resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
#    virtual_network_name = "${azurerm_virtual_network.cms-network.name}"
#    address_prefix       = "10.0.2.0/24"
#    service_endpoints    = ["Microsoft.Storage"]
#}


resource "azurerm_network_security_group" "admin" {
  name                = "admin_sg"
  location            = "${azurerm_resource_group.cms-rg.location}"
  resource_group_name = "${azurerm_resource_group.cms-rg.name}"

  tags = {
    environment = "${var.tag_environment}"
  }
}

resource "azurerm_network_security_rule" "sr-admin" {
  name                        = "sr-admin"
  priority                    = 100
  direction                   = "Inbound"
  access                      = "Allow"
  protocol                    = "*"
  source_port_range           = "*"
  destination_port_range      = "*"
  source_address_prefixes     = var.admin_whitelist
  destination_address_prefix  = "*"
  resource_group_name         = "${azurerm_resource_group.cms-rg.name}"
  network_security_group_name = "${azurerm_network_security_group.admin.name}"

}

resource "azurerm_network_security_rule" "sr-ui" {
  name                        = "sr-ui"
  priority                    = 200
  direction                   = "Inbound"
  access                      = "Allow"
  protocol                    = "Tcp"
  source_port_range           = "*"
  destination_port_ranges     = "${var.ui_ports}"
  source_address_prefixes     = "${var.external_whitelist}"
  destination_address_prefix  = "*"
  resource_group_name         = "${azurerm_resource_group.cms-rg.name}"
  network_security_group_name = "${azurerm_network_security_group.admin.name}"

}
