resource "google_compute_address" "cs_with_subnet_and_address" {
  # Static internal IPs for CS compute instances
  count        = var.cs_count
  name         = "${var.install_name}-cs-adress-${count.index}"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet-cms-cluster.name
  address_type = "INTERNAL"
  #address      = "10.1.0.${count.index + 16}"
  address      = cidrhost(var.gcp_subnet, count.index + 11)
}

resource "google_compute_instance" "cs" {
  # Scpecification of CS instances.
  count        = var.cs_count
  name         = "${var.install_name}-cs-${count.index}"
  machine_type = var.dev_mode ? var.gcp_instance_type_cs_dev : var.gcp_instance_type_cs

  //
  zone = "${var.region}-${var.zone}"

  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
    }
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet-cms-cluster.name
    network_ip = element(
      google_compute_address.cs_with_subnet_and_address.*.address,
      count.index,
    )
    // //access_config = {}
  }

  depends_on = [google_compute_instance.nfs]

  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo;echo -n 'net.ipv4.ip_forward=1' >> /etc/sysctl.conf;sysctl -p;ip addr add ${google_compute_address.cs_vip_external.address}/32 dev lo;ip addr add ${google_compute_address.cs_vip_internal.address}/32 dev lo;"

  metadata = {
    ssh-keys = "test:${file(var.public_key_path)}"
  }

  provisioner "remote-exec" {
    inline = [
      "sudo mkdir -p /opt/vmTools",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
    ]

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "file" {
    source      = "../vmTools/"
    destination = "/opt/vmTools"

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo mkdir -p /opt/cms/staging/config",
      "sudo chown -R ${var.ssh_user}:${var.ssh_user} /opt/cms/staging",
    ]

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "file" {
    source      = template_dir.config.destination_dir
    destination = "/opt/cms/staging/"

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "file" {
    source      = var.package_location
    destination = "~${var.ssh_user}/packages"

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
      timeout     = "30m"
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo chmod +x /opt/vmTools/*.sh",
      "sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
      "sudo bash /opt/vmTools/mountVMdisk.sh /vol1 \"0% 100%\"",
      "sudo bash /opt/vmTools/setupNFSServer.sh /vol1",
      "sudo bash /opt/vmTools/setHostname.sh ${var.cms_hostname_cs}${count.index + 1}",
      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
      "sudo setenforce 0",
      "sudo sed -i --follow-symlinks 's/^SELINUX=.*/SELINUX=disabled/g' /etc/sysconfig/selinux",
      "sudo yum erase -y python-setuptools",
      "if [ ${count.index} == '0' ]; then",
      "cd ~${var.ssh_user}/packages/",
      "sudo yum install -y `ls *.rpm`",
      "sudo bash /opt/repos/scripts/create_httpd_repo.sh ${self.network_interface[0].network_ip}",
      "sudo systemctl restart httpd",
      "sudo mv /opt/cms/staging/config /opt/cms/installer/staging/.",
      "sudo cat << EOF | sudo tee /opt/cms/installer/staging/files/license.xml",
      file(var.license_file_path),
      "EOF",
      "sudo bash /opt/cms/installer/create_config_package.sh",
      "fi",
      "sudo systemctl stop firewalld",
      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${google_compute_address.cs_with_subnet_and_address[0].address}:8008/cms-node-config.tgz",
      "cd /opt/cms/staging",
      "sudo bash installcmsnode.sh -n ${var.cs_count} cs${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
    ]

    #"sudo echo -n 'net.ipv4.ip_forward=1' >> /etc/sysctl.conf",
    #"sudo sysctl -p",

    #"sudo echo -n 'net.ipv4.ip_forward=1' >> /etc/sysctl.conf",
    #"sudo sysctl -p",

    connection {
      host = element(
        google_compute_instance.cs.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
      timeout     = "60m"
    }
  }
}

#resource "null_resource" "cs_cluster_vip_exist" {
#  count = var.cs_count
#
#  triggers = {
#    cs_vip_loadbalancer = join(
#      ",",
#      google_compute_forwarding_rule.cs_forwarding_rule_external.*.self_link,
#    )
#  }
#
#  connection {
#    type = "ssh"
#    host = element(
#      google_compute_instance.cs.*.network_interface.0.network_ip,
#      count.index,
#    )
#    user        = var.ssh_user
#    private_key = file(var.private_key_path)
#    timeout     = "60m"
#  }
#
#  provisioner "remote-exec" {
#    inline = [
#      "cd /opt/cms/staging",
#      "sudo bash installcmsnode.sh -n ${var.cs_count} cs${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
#    ]
#  }
#
#  depends_on = [google_compute_forwarding_rule.cs_forwarding_rule_external]
#}
