resource "google_compute_address" "cs_vip_internal" {
  name         = "cs-${var.install_name}-${var.region}-ip-internal"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet-cms-cluster.name
  address_type = "INTERNAL"
}

resource "google_compute_address" "cs_vip_external" {
  name         = "cs-${var.install_name}-${var.region}-ip-external"
  region       = var.region
  address_type = "EXTERNAL"
}

# External Forwarding rules
resource "google_compute_forwarding_rule" "cs_forwarding_rule_external" {
  count                 = length(concat(var.ui_ports, var.internal_lb_ports))
  project               = var.project
  name                  = "${var.install_name}-cs-internal-${element(concat(var.ui_ports, var.internal_lb_ports), count.index)}"
  region                = var.region
  load_balancing_scheme = "EXTERNAL"
  target                = google_compute_target_pool.cs_pool.self_link
  ip_address            = google_compute_address.cs_vip_external.self_link
  ip_protocol           = var.ip_protocol

  port_range = element(concat(var.ui_ports, var.internal_lb_ports), count.index)
}

# Internal Forwardign rules
/*
resource "google_compute_forwarding_rule" "cs_forwarding_rule_internal" {
  #count                 = "${length(concat(var.ui_ports,var.internal_lb_ports))}"
  project               = "${var.project}"
  #name                  = "${var.name}-cs-internal-${element(concat(var.ui_ports,var.internal_lb_ports),count.index)}"
  name                  = "${var.name}-cs-internal"
  region                = "${var.region}"
  network               = "${google_compute_network.cms-network.self_link}"
  subnetwork            = "${google_compute_subnetwork.subnet-cms-cluster.self_link}"
  load_balancing_scheme = "INTERNAL"
  backend_service       = "${google_compute_region_backend_service.cs_backend.self_link}"
  ip_address            = "${google_compute_address.cs_vip_internal.self_link}"
  ip_protocol           = "${var.ip_protocol}"

  #ports                 = ["${element(concat(var.ui_ports,var.internal_lb_ports),count.index)}"]
  #allports = "true"
}
*/

resource "google_compute_region_backend_service" "cs_backend" {
  project          = var.project
  name             = "${var.install_name}-cs"
  region           = var.region
  protocol         = var.ip_protocol
  timeout_sec      = 10
  session_affinity = var.session_affinity

  backend {
    group = google_compute_instance_group.cs_group.self_link
  }

  health_checks = [google_compute_health_check.cs-consul.self_link]
}

resource "google_compute_health_check" "cs-consul" {
  name = "${var.install_name}-consul-8501-ui"

  http_health_check {
    port         = "8501"
    request_path = "/ui/"
  }
}

# Target pool for CS servers
resource "google_compute_target_pool" "cs_pool" {
  name      = "${var.install_name}-cs-pool"
  instances = google_compute_instance.cs.*.self_link
  //health_checks = ["${element(compact(concat(google_compute_health_check.tcp.*.self_link)), 0)}"]
}

# Unmanaged Instance group for CS
resource "google_compute_instance_group" "cs_group" {
  name        = "${var.install_name}-cs-group-test"
  description = "CS unmanaged group"
  zone        = "${var.region}-${var.zone}"
  network     = google_compute_network.cms-network.self_link

  instances  = google_compute_instance.cs.*.self_link
  depends_on = [google_compute_instance.cs]
}