resource "google_compute_network" "cms-network" {
  name                    = "${var.install_name}-cms-network"
  description             = "Network that is use for host CMS installation"
  auto_create_subnetworks = "false"
}

### Add Cloud NAT 
## Set minimum ports to 128 to adapte to kibana import process, default is 64
resource "google_compute_router_nat" "cloud-nat" {
  provider                           = google
  name                               = "${var.install_name}-cloud-nat"
  router                             = google_compute_router.cloud-nat.name
  nat_ip_allocate_option             = "AUTO_ONLY"
  source_subnetwork_ip_ranges_to_nat = "ALL_SUBNETWORKS_ALL_IP_RANGES"
  region                             = var.region
  min_ports_per_vm                   = 128
}

resource "google_compute_router" "cloud-nat" {
  name    = "${var.install_name}-cloud-nat"
  network = google_compute_network.cms-network.self_link
}

data "google_compute_network" "default" {
  name = "bastion"
}

# Peer from Bstion host (default) to CMS instances (cms-network)
resource "google_compute_network_peering" "bastion2cms" {
  name         = "${var.install_name}-bastion2cms"
  network      = data.google_compute_network.default.self_link
  peer_network = google_compute_network.cms-network.self_link
  #auto_create_routes = true
}

resource "google_compute_network_peering" "cms2bastion" {
  name         = "${var.install_name}-cms2bastion"
  network      = google_compute_network.cms-network.self_link
  peer_network = data.google_compute_network.default.self_link
  #auto_create_routes = true
}

## Peer VPCs with MFVP project
#resource "google_compute_network_peering" "tvaas-peering-cms-mfvp" {
#  name               = "tvaas-peering-cms-mfvp"
#  network            = "${google_compute_network.cms-network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-mfvp/global/networks/tvaas-mfvp"
#  auto_create_routes = true
#}
#
## Peer VPCs with VSPP project
#resource "google_compute_network_peering" "tvaas-peering-mfvp-vspp" {
#  name               = "tvaas-peering-mfvp-vspp"
#  network            = "${google_compute_network.cms-network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-vspp/global/networks/default"
#  auto_create_routes = true
#}

resource "google_compute_subnetwork" "subnet-cms-cluster" {
  name          = "${var.install_name}-subnet-cms-cluster"
  ip_cidr_range = var.gcp_subnet
  region        = var.region
  network       = google_compute_network.cms-network.name
  #private_ip_google_access = "true"
}

resource "google_compute_firewall" "defaut-ingress" {
  name    = "${var.install_name}-default-ingress"
  network = google_compute_network.cms-network.name

  allow {
    protocol = "TCP"
    ports    = concat(var.ui_ports, var.internal_lb_ports)
  }

  direction = "INGRESS"
}

resource "google_compute_firewall" "defaut-internal-ingress" {
  name    = "${var.install_name}-default-internal-ingress"
  network = google_compute_network.cms-network.name

  source_ranges = ["192.168.0.0/24", "10.128.0.0/9", "${var.gcp_subnet}"]

  allow {
    protocol = "all"
  }

  direction = "INGRESS"
}

resource "google_compute_firewall" "defaut-egress" {
  name    = "${var.install_name}-default-egress"
  network = google_compute_network.cms-network.name

  allow {
    protocol = "all"
  }

  direction = "EGRESS"
}
