# Create NFS server
resource "google_compute_instance" "nfs" {
  name         = "${var.install_name}-nfs"
  machine_type = "n1-highmem-2"

  //
  zone = "${var.region}-${var.zone}"

  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
    }
  }

  attached_disk {
    source      = google_compute_disk.nfs_disk.id
    device_name = google_compute_disk.nfs_disk.name
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet-cms-cluster.name
    network_ip = cidrhost(var.gcp_subnet, 5)
    //access_config = {}
  }

  metadata_startup_script = file("../scripts/nfs.sh")

  metadata = {
    device_name = "google-${google_compute_disk.nfs_disk.name}"
  }

  depends_on = [google_sql_database_instance.cloudsql_master]
}

# Create persistent disk
resource "google_compute_disk" "nfs_disk" {
  name = "${var.install_name}-nfs-disk"
  type = "pd-standard"
  zone = "${var.region}-${var.zone}"
  size = "3300"

  labels = {
    service = "nfs"
  }
}
