variable "project" {
  description = "project ID"
  default     = "tvaas-poc"
}

variable "name" {
  description = "CMS"
  default     = "tvaas"
}

variable "region" {
  default = "us-east1"
}

variable "zone" {
  default = "b"
 description = "Zone (a/b/c) within the region.  Will be concatenated with the region"
}

# Installation Identifier - every concurrent deployment needs a unique install name
variable "install_name" {
  description = "Textual Name of this CMS Install"
}

##TODO: this doesn't seem to be used?
# GCP Details - where and how to create the install
variable "gcp_region" {
  description = "GCP region to launch vms into"
  default     = "us-east1"
}

variable "app_count" {
  description = "number of application nodes to deploy"
  default     = "1"
}

variable "cs_count" {
  description = "number of Cluster Service nodes to deploy"
  default     = "1"
}

variable "es_count" {
  description = "number of ElasticSearch nodes to deploy"
  default     = "1"
}

variable "pt_count" {
  description = "number of Portal nodes to deploy"
  default     = "0"
}

####CT nodes installation
variable "ct_count" {
    description = "number of Content nodes to deploy"
    default = 0
}

variable "cloud_ext_ct" {
    description =  "To determine whether CT nodes need to be installed inside or outside aws."
    default = false
}

variable "rds_multi_az" {
  description = "true to deploy database with high availability"
  default     = false
}

variable "az_count" {
  description = "number of availability zones to spread across"
  default     = 3
}

variable "dev_mode" {
  description = "True to run in development mode (smaller/cheaper instance types, output nodes to file for automated tests)"
  default     = true
}

variable "mount_options" {
  description = "mount options for EFS"
  default     = ["nolock", "nfsvers=4.1"]
}

variable "remount" {
  description = "enable/disable remount as a mount option; should remain false for EFS"
  default     = false
}

variable "cms_nas_share" {
    description = "The nas share folder for cms"
    default = "/var/nfsshare/app"
}

variable "content_nas_share" {
    description = "The nas share folder for content"
    default = "/var/nfsshare/content"
}

# Security Firewall configuration

variable "admin_whitelist" {
  description = "networks to allow admin connectivity from"
  default     = []
}

# must match the company NAT rules in use to allow access to the install from the company network
variable "external_whitelist" {
  description = "networks to allow external connectivity from - replace with corporate public IP address range from corporate Nat/gateway; limit to 5"
  default     = []
}

variable "bastion_public_cidr" {
  description = "the public IP cidr of the bastion system, used to kickstart the deployment.  This IP must be allowed in the security groups.  i.e.   dig +short myip.opendns.com @resolver1.opendns.com"
  default     = []
}

variable "ui_ports" {
  description = "Accessible CMS UI ports"
  default     = ["21", "80", "8081", "8443", "8501", "9292", "9393", "16443", "5672"]
}

variable "internal_lb_ports" {
  description = "Internal CMS load balanced ports"
  default     = ["5000", "6003", "7070", "7443", "8080"]
}

variable "cs_ports" {
  description = "Accessible CMS ports for CS nodes"
  default     = ["5601", "9090"]
}

# Networking Defaults
variable "gcp_vpc_cidr" {
  description = "The CIDR of the VPC to create."
  default     = "10.1.0.0/16"
}

variable "gcp_subnet" {
  description = "The CIDR of the Subnet to create with the VPC. All VMs are created in this subnet, which is broken up into smaller subnets for each availability zone. Must be a valid subnet of the VPC cidr."
  default     = "10.1.0.0/24"
}

variable "rds_subnet_cidr" {
  description = "The CIDR of the Subnet to create with the VPC for RDS instances. Must be a valid subnet of the VPC cidr."
  default     = "10.1.1.0/24"
}

# Instance Type selection for the vms
variable "gcp_instance_type_cs" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances."
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_cs_dev" {
  description = "The GCP Instance Type to use for CMS Cluster Server Instances in development mode"
  default     = "n1-standard-2"
}

variable "gcp_instance_type_app" {
  description = "The GCP Instance Type to use for CMS Application Server Instances."
  default     = "n1-standard-16"
}

variable "gcp_instance_type_app_dev" {
  description = "The GCP Instance Type to use for CMS Application Server Instances in development mode"
  default     = "n1-standard-2"
}

variable "gcp_instance_type_rds" {
  description = "The GCP Instance Type to use for GCP PostgreSQL RDS Instances."
  default     = "n1-highmem-8"
}

variable "gcp_instance_type_rds_dev" {
  description = "The GCP Instance Type to use for GCP PostgreSQL RDS Instances in development mode"
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_es" {
  description = "The GCP Instance Type to use for CMS Elastic Search Server Instances. "
  default     = "n1-highmem-4"
}

variable "gcp_instance_type_es_dev" {
  description = "The GCP Instance Type to use for CMS Elastic Search Server Instances in development mode"
  default     = "n1-standard-2"
}

variable "gcp_instance_type_pt" {
  description = "The GCP Instance Type to use for CMS Portal Server Instances.   Install will fail if this value is lowered."
  default     = "n1-standard-1"
}

# Instance Volume Type
# select one of standard, gp2 or io1
#  standard = magnetic
#  gp2 = General Provision SSD
#  io1 = Provisioned IOPS SSD

variable "root_volume_type" {
  description = "Volume type to use on boot/root disk"
  default     = "standard"
}

variable "block_volume_type" {
  description = "Volume type to use on additional file system space"
  default     = "standard"
}

# Instance Disk Space expansion
# amount of additional disk space to alloate to each instances

variable "gcp_instance_block_size_cs" {
  description = "Number of GB of additional space to alloate to Cluster Server instances"
  default     = "20"
}

variable "gcp_instance_block_size_app" {
  description = "Number of GB of additional space to alloate to Application Server instances"
  default     = "20"
}

variable "gcp_instance_block_size_es" {
  description = "Number of GB of additional space to alloate to Elastic Search Server instances"
  default     = "100"
}

variable "gcp_instance_block_size_pt" {
  description = "Number of GB of additional space to alloate to Portal Server instances"
  default     = "20"
}

# NAS Backing Block Details

variable "content_nas_volume_size" {
  description = "Number of GB to allocate for contenet share"
  default     = "100"
}

variable "content_nas_volume_type" {
  description = "Type of gcp block device to allocate for content share"
  default     = "standard"
}

# Location of installation media

variable "cms_softwareonly_s3_bucket_url" {
  description = "GCP URL to the s3 bucket containing the CMS softwareOnly rpm to intall"
  default     = ""
}

variable "cms_prepack_release" {
  description = "The PrePack installation tar file - should be avaiable at the var.cms_softwareonly_s3_bucket_url "
  default     = "prepack-aio-master-SNAPSHOT.3398.tar.gz"
}

variable "cms_prepack_component_selection" {
  description = "Filename of CMS PrePack component selection json file"
  default     = "prepack-component-selections.json"
}

variable "cms_prepack_component_response" {
  description = "Character input pattern to use during install of prepack deploy.sh - for install with no prompts."

  default = <<EOV
4
yes
yes

EOV
}

variable "cms_prepack_patch" {
  description = "The PrePack installation patch file - should be avaiable at the var.cms_softwareonly_s3_bucket_url "
  default     = ""
}

# CMS License & Fingerprint

variable "cms_license_fingerprint" {
  description = "CMS Installation License Fingerprint - do not change"
  default     = "00000000000000000000000000000000"
}

variable "customerInstanceId" {
  description = "A value used internally - mostly here for legacy purposes"
  default     = "cms"
}

variable "license_file_path" {
  description = "Path to CMS license file - do not change"
  default     = "../license.xml"
}

variable "prepack_license_file_path" {
  description = "Path to CMS prepack license file - do not change"
  default     = "../prepackLicense.xml"
}

# Instance Hostname/domain details

variable "cms_hostname_cs" {
  description = "The hostname prefix for the Cluster Server Instance"
  default     = "cms-cs"
}

variable "cms_hostname_app" {
  description = "The hostname prefix for the Application Server Instance"
  default     = "cms-app"
}

variable "cms_hostname_es" {
  description = "The hostname prefix for the Elastic Search Server Instance"
  default     = "cms-es"
}

variable "cms_hostname_pt" {
  description = "The hostname prefix for the Portal Server Instance"
  default     = "cms-pt"
}

variable "cms_dns_domain" {
  description = "Network Domain name for CMS Instances"
  default     = "ericsson.local"
}

variable "timezone" {
  description = "Timezone to run the Instances in..."
  default     = "America/Los_Angeles"
}

variable "ntp1" {
  description = "First ntp server ip"
  default     = "0.rhel.pool.ntp.org"
}

variable "ntp2" {
  description = "Second ntp server ip"
  default     = "1.rhel.pool.ntp.org"
}

variable "snmp_server" {
  description = "SNMP server"
  default     = "127.0.0.1"
}

# Configuration template
variable "config_json_template" {
  description = "Path to CMS Configuration file template - do not change"
  default     = "../software1nonHA.tpl"
}

variable "config_install_sysInfo_template" {
  description = "PrePack install sysInfo file"
  default     = "../prepackTools/install_sysInfo_1NonHA.tpl"
}

# Base Operation System image to install - add more regions as needed...
variable "gcp_ami_product_code" {
  description = "AMI product code identifiers to use in various regions - should be CentOS 7"
  default     = "aw0evgkw8e5c1q413zgy5pjce"                                                   # CentOS 7 (x86_64) - with Updates HVM
}

# SSH Key Details
# this allows ssh into the instances via keys on the bastion system.

variable "private_key_path" {
  description = "The path of the ssh private key the bastion will use to configure instances"
  default     = "~/.ssh/test"
}

variable "public_key_path" {
  description = "The path of the ssh pub key the bastion will use to configure instances"
  default     = "~/.ssh/test.pub"
}

variable "ssh_user" {
  description = "user to ssh as"
  default     = "test"
}

variable "db_version" {
  description = "Use this to set the db version for RDS instance creation."
  default     = "9.5"
}

variable "db_minor_version" {
  description = "Use this to set the db version for RDS instance creation."
  default     = "12"
}

variable "db_name" {
  description = "Use this to set the db name for RDS instance creation."
  default     = "ttv"
}

variable "db_port" {
  description = "Use this to set the db port for RDS instance creation."
  default     = "5432"
}

variable "db_user" {
  description = "Use this to set the db user for RDS instance creation."
  default     = "postgres"
}

variable "db_pass" {
  description = "Use this to set the db password for RDS instance creation."
  default     = "n2Cdf92j"
}

variable "package_location" {
  description = "Location of CMS packages to install"
  default     = "../packages"
}

variable session_affinity {
  description = "The session affinity for the backends example: NONE, CLIENT_IP. Default is `NONE`."
  default     = "NONE"
}

variable ports {
  description = "List of ports range to forward to backend services. Max is 5."
  type        = "list"
}

variable http_health_check {
  description = "Set to true if health check is type http, otherwise health check is tcp."
  default     = false
}

variable health_port {
  description = "Port to perform health checks on."
  default     = "80"
}

variable source_tags {
  description = "List of source tags for traffic between the internal load balancer."
  type        = "list"
}

variable target_tags {
  description = "List of target tags for traffic between the internal load balancer."
  type        = "list"
}

variable ip_address {
  description = "IP address of the internal load balancer, if empty one will be assigned. Default is empty."
  default     = ""
}

variable ip_protocol {
  description = "The IP protocol for the backend and frontend forwarding rule. TCP or UDP."
  default     = "TCP"
}

variable network_project {
  description = "Name of the project for the network. Useful for shared VPC. Default is var.project."
  default     = ""
}

variable filestore_name {
  default = "cms"
}
