resource "aws_db_instance" "rds" {
    depends_on = ["aws_db_subnet_group.db_subnet_group","aws_network_interface.cs_int"]
    tags {
        Name = "rds${count.index + 1}-${var.install_name}"
    }
    multi_az = "${var.rds_multi_az}"
    allocated_storage = 100
    storage_type = "gp2"
    skip_final_snapshot = true
    engine = "postgres"
    engine_version = "${var.rds_db_version}.${var.rds_db_minor_version}"
    instance_class = "${var.dev_mode ? var.aws_instance_type_rds_dev : var.aws_instance_type_rds}"
    name = "${var.rds_db_name}"
    port = "${var.rds_db_port}"
    username = "${var.rds_db_user}"
    password = "${var.rds_db_pass}"
    db_subnet_group_name = "${aws_db_subnet_group.db_subnet_group.id}"
    parameter_group_name = "default.postgres${var.rds_db_version}"
    vpc_security_group_ids = ["${aws_security_group.rds_security_group.id}"]
}

output "rds endpoint" {
    value = "${aws_db_instance.rds.endpoint}"
}
