export NFSSERVER=$(curl http://metadata.google.internal/computeMetadata/v1/instance/attributes/nfs_server -H "Metadata-Flavor: Google")
export HOSTNAME=$(curl http://metadata.google.internal/computeMetadata/v1/instance/hostname -H "Metadata-Flavor: Google")
#!/bin/bash
mkdir -p /opt/cms/staging/config
mkdir -p /opt/vmTools
# have to tell the network NOT to create an /etc/resolv.conf based on what comes back from AWS DHCP - we need cms/ours not theirs
yum install nfs-utils nfs-utils-lib -q -y

# set to start
chkconfig --levels 235 nfs on
chkconfig --levels 235 rpcbind on

# start services
service rpcbind start
service nfs start

# create share
echo "$NFSSERVER	*(rw,sync,no_root_squash,no_subtree_check)" >> /etc/exports

# share it
exportfs -a

"echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0"
# set the hostname
hostname $HOSTNAME
sed -i "/HOSTNAME=localhost.localdomain/c\\HOSTNAME=$HOSTNAME" /etc/sysconfig/network
#turn off SELinux
setenforce 0
sed -i --follow-symlinks 's/^SELINUX=.*/SELINUX=disabled/g' /etc/sysconfig/selinux

#remove packages which will conflict with CMS packages
yum erase -y python-setuptools

systemctl stop firewalld