# Build number: 8.0.000.3

# CMS Configuration config.json files
resource "template_dir" "config" {
    source_dir = "${path.module}/config_templates",
    destination_dir = "${path.cwd}/config"

    vars {
        customerLicenseId = "${var.cms_license_fingerprint}"
        privateNetmask = "${cidrnetmask(var.aws_subnet_cidr)}"
        # DNS services are on .2 of the vpc subnet by AWS
        vpc_dns = "${cidrhost(var.aws_vpc_cidr, 2)}"
        consul_servers = "${var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\"" }"
        named_master = "${element(flatten(aws_network_interface.cs_int.*.private_ips), 0)}"
        named_slaves = "${jsonencode(slice(flatten(aws_network_interface.cs_int.*.private_ips), 1, length(flatten(aws_network_interface.cs_int.*.private_ips))))}"
        cms_nas_server = "${aws_efs_file_system.cms.dns_name}"
        content_nas_server = "${aws_efs_file_system.content.dns_name}"
        ct_cms_nas_server = "${ join("", aws_efs_file_system.ct.*.dns_name)}"
        ct_content_nas_server = "${join("", aws_efs_file_system.ct_content.*.dns_name)}"
        mountOptions = "${join(",", var.mount_options)}"
        remount = "${var.remount}"
        privateDomain = "${var.cms_dns_domain}"
        ui_eip = "${var.ct_count > 0 ? aws_lb.internal_vip.dns_name : aws_lb.ui_vip.dns_name}"
        app_eip = "${aws_lb.internal_vip.dns_name}"
        timezone = "${var.timezone}"
        dbserver = "${aws_db_instance.rds.address}"
        snmpServer = "${var.snmp_server}"
        privateNetwork = "${cidrhost(var.aws_subnet_cidr,0)}"
        customerInstanceId = "${var.customerInstanceId}"
        installName = "${var.install_name}"
        cloudextct = "${var.cloud_ext_ct ? true : false }"
        hasct = "${((var.ct_count > 0 ?  1 : 0 ) + (var.cloud_ext_ct ? 1 : 0 )) >= 1 ? true : false }"
    }
}

#create a file with variables pointing to deployed nodes for use by jenkins jobs
data "template_file" "nodes" {
    template = "${file("nodes.sh.tpl")}"

    vars {
        customerInstanceId = "${var.customerInstanceId}"
        uiVip = "${aws_lb.ui_vip.dns_name}"
        csIps = "${join(" ",aws_instance.cs.*.public_ip)}"
        esIps = "${join(" ",aws_instance.es.*.public_ip)}"
        appIps = "${join(" ",aws_instance.app.*.public_ip)}"
        ptIps = "${join(" ",aws_instance.pt.*.public_ip)}"
        dbHost = "${replace(aws_db_instance.rds.endpoint,"/(.*):.*/","$1")}"
    }
}

resource "null_resource" "nodes" {
    provisioner "local-exec" {
        command = "echo \"${data.template_file.nodes.rendered}\" | sudo tee nodes.sh"
    }
}

# Prepack Configuration file - install_sysInfo.tpl -> install_sysInfo.json
data "template_file" "init2" {
    template = "${file(var.config_install_sysInfo_template)}"

    vars {
        installerIP = "${element(flatten(aws_network_interface.cs_int.*.private_ips), 0)}"
    }
}

output "cms_operator_ui" {
    value = "https://${aws_lb.ui_vip.dns_name}:8443"
}

output "cms_central_logger_ui" {
    value = "http://${aws_lb.ui_vip.dns_name}:9292"
}

output "cms_consul_ui" {
    value = "http://${aws_lb.ui_vip.dns_name}:8501"
}
