# Creating EFS file system for cms mount
resource "aws_efs_file_system" "cms" {
    creation_token = "cms_mount-${var.install_name}"
    tags {
        Name = "cms_mount-${var.install_name}"
    }
}

# Creating EFS mount target for cms mount
resource "aws_efs_mount_target" "cms" {
    count = "${min(length(data.aws_availability_zones.available.names),var.az_count)}"
    file_system_id = "${aws_efs_file_system.cms.id}"
    subnet_id = "${element(aws_subnet.default.*.id, count.index)}"
    security_groups = ["${aws_security_group.private.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}

# Creating EFS file system for content mount
resource "aws_efs_file_system" "content" {
    creation_token = "content_mount-${var.install_name}"
    tags {
        Name = "content_mount-${var.install_name}"
    }
}

# Creating EFS mount target for content mount
resource "aws_efs_mount_target" "content" {
    count = "${min(length(data.aws_availability_zones.available.names),var.az_count)}"
    file_system_id = "${aws_efs_file_system.content.id}"
    subnet_id = "${element(aws_subnet.default.*.id, count.index)}"
    security_groups = ["${aws_security_group.private.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}

# Creating EFS file system for ct nodes cms mount
resource "aws_efs_file_system" "ct" {
    count = "${(var.ct_count > 0 ? 1 : 0) * (!var.cloud_ext_ct ? 1 : 0)}"
    creation_token = "ct_mount-${var.install_name}"
    tags {
        Name = "ct_mount-${var.install_name}"
    }
}

# Creating EFS mount target for ct nodes mount
resource "aws_efs_mount_target" "ct" {
    count = "${(var.ct_count > 0 ? 1 : 0) * (!var.cloud_ext_ct ? 1 : 0) * min(length(data.aws_availability_zones.available.names),var.az_count)}"
    file_system_id = "${aws_efs_file_system.ct.id}"
    subnet_id = "${element(aws_subnet.default.*.id, count.index)}"
    security_groups = ["${aws_security_group.private.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}

# Creating EFS file system for ct nodes content mount
resource "aws_efs_file_system" "ct_content" {
    count = "${(var.ct_count > 0 ? 1 : 0) * (!var.cloud_ext_ct ? 1 : 0)}"
    creation_token = "ct_content_mount-${var.install_name}"
    tags {
        Name = "ct_content_mount-${var.install_name}"
    }
}

# Creating EFS mount target for ct nodes content mount
resource "aws_efs_mount_target" "ct_content" {
    count = "${(var.ct_count > 0 ? 1 : 0) * (!var.cloud_ext_ct ? 1 : 0) * min(length(data.aws_availability_zones.available.names),var.az_count)}"
    file_system_id = "${aws_efs_file_system.ct_content.id}"
    subnet_id = "${element(aws_subnet.default.*.id, count.index)}"
    security_groups = ["${aws_security_group.private.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}
