resource "google_compute_instance" "es" {
  count        = var.es_count
  name         = "es-${count.index}"
  machine_type = var.dev_mode ? var.gcp_instance_type_es_dev : var.gcp_instance_type_es

  //
  zone = "${var.region}-${var.zone}"

  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
    }
  }

  network_interface {
    subnetwork = google_compute_subnetwork.subnet-us-west1-tvaas-poc.name
    network_ip = element(
      google_compute_address.es_with_subnet_and_address.*.address,
      count.index,
    )
    //access_config = {}
  }

  metadata = {
    ssh-keys = "test:${file(var.public_key_path)}"
  }

  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo"
  depends_on              = [google_compute_instance.cs]

  provisioner "remote-exec" {
    inline = [
      "sudo mkdir -p /opt/vmTools",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
    ]

    connection {
      host = element(
        google_compute_instance.es.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "file" {
    source      = "vmTools/"
    destination = "/opt/vmTools"

    connection {
      host = element(
        google_compute_instance.es.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo chmod +x /opt/vmTools/*.sh",
      "sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
      "sudo bash /opt/vmTools/setHostname.sh ${var.cms_hostname_es}${count.index + 1}",
      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
      "sudo yum erase -y python-setuptools",
      "sudo systemctl stop firewalld",
      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${google_compute_address.cs_with_subnet_and_address[0].address}:8008/cms-node-config.tgz",
      "cd /opt/cms/staging",
      "sudo bash installcmsnode.sh -n ${var.es_count} es${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
    ]

    connection {
      host = element(
        google_compute_instance.es.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
      timeout     = "60m"
    }
  }
}

resource "google_compute_address" "es_with_subnet_and_address" {
  count        = var.es_count
  name         = "es-adress-${count.index}"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet-us-west1-tvaas-poc.name
  address_type = "INTERNAL"

  #region       = "${var.region}"
  address = "10.0.0.${count.index + 32}"
}
