resource "google_compute_network" "cms-network" {
  name                    = "cms-network"
  description             = "Network that is use for host CMS installation"
  auto_create_subnetworks = "false"
}

### Add Cloud NAT 

resource "google_compute_router_nat" "cloud-nat" {
  provider                           = google
  name                               = "cloud-nat"
  router                             = google_compute_router.cloud-nat.name
  nat_ip_allocate_option             = "AUTO_ONLY"
  source_subnetwork_ip_ranges_to_nat = "ALL_SUBNETWORKS_ALL_IP_RANGES"
  region                             = var.region
}

resource "google_compute_router" "cloud-nat" {
  name    = "cloud-nat"
  network = google_compute_network.cms-network.self_link
}

data "google_compute_network" "default" {
  name = "bastion"
}

# Peer from Bstion host (default) to CMS instances (cms-network)
resource "google_compute_network_peering" "bastion2cms" {
  name         = "bastion2cms"
  network      = data.google_compute_network.default.self_link
  peer_network = google_compute_network.cms-network.self_link
  #auto_create_routes = true
}

resource "google_compute_network_peering" "cms2bastion" {
  name         = "cms2bastion"
  network      = google_compute_network.cms-network.self_link
  peer_network = data.google_compute_network.default.self_link
  #auto_create_routes = true
}

## Peer VPCs with MFVP project
#resource "google_compute_network_peering" "tvaas-peering-cms-mfvp" {
#  name               = "tvaas-peering-cms-mfvp"
#  network            = "${google_compute_network.cms-network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-mfvp/global/networks/tvaas-mfvp"
#  auto_create_routes = true
#}
#
## Peer VPCs with VSPP project
#resource "google_compute_network_peering" "tvaas-peering-mfvp-vspp" {
#  name               = "tvaas-peering-mfvp-vspp"
#  network            = "${google_compute_network.cms-network.self_link}"
#  peer_network       = "https://www.googleapis.com/compute/v1/projects/tvaas-poc-vspp/global/networks/default"
#  auto_create_routes = true
#}

resource "google_compute_subnetwork" "subnet-us-west1-tvaas-poc" {
  name          = "subnet-us-west1-tvaas-poc"
  ip_cidr_range = var.gcp_subnet
  region        = var.region
  network       = google_compute_network.cms-network.name
  #private_ip_google_access = "true"
}

resource "google_compute_firewall" "defaut-ingress" {
  name    = "default-${var.install_name}-ingress"
  network = google_compute_network.cms-network.name

  allow {
    protocol = "TCP"
    ports    = concat(var.ui_ports, var.internal_lb_ports)
  }

  direction = "INGRESS"
}

resource "google_compute_firewall" "defaut-internal-ingress" {
  name    = "default-${var.install_name}-internal-ingress"
  network = google_compute_network.cms-network.name

  source_ranges = ["192.168.0.0/24", "10.128.0.0/9", "10.0.0.0/24"]

  allow {
    protocol = "all"
  }

  direction = "INGRESS"
}

resource "google_compute_firewall" "defaut-egress" {
  name    = "default-${var.install_name}-egress"
  network = google_compute_network.cms-network.name

  allow {
    protocol = "all"
  }

  direction = "EGRESS"
}

resource "google_compute_global_address" "private_ip_address" {
  provider      = google-beta
  name          = "private-ip-address"
  purpose       = "VPC_PEERING"
  address_type  = "INTERNAL"
  prefix_length = 16
  network       = google_compute_network.cms-network.self_link
}

resource "google_service_networking_connection" "private_vpc_connection" {
  provider                = google-beta
  network                 = google_compute_network.cms-network.self_link
  service                 = "servicenetworking.googleapis.com"
  reserved_peering_ranges = [google_compute_global_address.private_ip_address.name]
}
