# CMS terraform AWS template 

##

```
git clone http://git.connectedwater.net/ebilhoo/cmsform.git
```

## Overview
Using terraform to automate the deployment of a SoftwareOnly install of CMS in a non-HA setup onto AWS Cloud for Development purposes. 


**NOTE: this readme is outdated and needs updating.  See CMS install doc for latest instructions** 




The install uses a bastion system running in a VPC to drive the terraform commands. 

## CMS-bastion
- EC2 Launch
- Centos 6.5 AMI - ami-8997afe0 
- m3.medium
- Auto-assign Public IP: Enabled
- 8GB storage default
- Allow SSH only from Corporate sources - not public!
- Terraform 0.9.4

## Current Bastion in AWS
There is a current bastion in AWS Region US East at 204.236.212.251 (it might be stopped - start it if needed)

su to terraform and look for the project files in the cmsform folder.

`terraform plan -var-file=Developer1.tfvars`

`terraform apply -var-file=Developer1.tvars`

## Prep Steps to create a new Bastion
- Create an S3 Bucket in AWS for CMS
- Obtain the CMS SoftwareOnly installer rpm and upload to the S3 bucket
- Obtain the CMS AIO PrePack installer tar and upload to the S3 bucket
- Update the variable.tf file with the s3 bucket location and name of the softwareOnly installer rpm.
- Grant read access to the files in S3
- Obtain the bastion system public IP and update the variables.tf file with this address/32 at the bastion\_public\_cidr variable. This allow the bastion access to the installs such that it can create them. ( `$ dig +short myip.opendns.com @resolver1.opendns.com` will give your public ip) 
- Obtain your corporate nat resolution to know what IP addresses you appear to in AWS.  Update the variables.ft file in the external_whitelist variable such that you can access the instances from your corporate network into AWS.

## Deploy a CMS Install
Git clone the source from git onto a new folder. 
Update the sample1.tfvars with values for the following

- install\_name, Each install name must be unique, Dev-1, Dev-2 etc
- aws\_region - AWS Region to create install
- aws\_access\_key, API Access KEY to account to use for AWS install
- aws\_secret\_key, API Secret Key to access to use for AWS install

Mulitple tfvar files can be created to create multiple installs.


Place the CMS license file (license.xml) in the same directory as the terraform files (cmsform).

Update the variables.tf file to match the fingerprint of the license file at variable cms_license_fingerprint

Execute the terraform script to deploy the software

`$ terraform apply -var-file=sample1.tfvars`

To destroy the install (and release AWS resources)

`$ terraform destroy -force`

##When things go right

The Terraform install will complete in about 1/2 an hour with the URLs to various CMS resources created in AWS.   Specifically try the operator ui - default login passwords apply.


Outputs:

cms\_central\_logger ui = http://X.X.X.X:9292

cms\_consul\_ui = http://X.X.X.X:8500

cms\_haproxy\_ui = http://X.X.X.X:9090

cms\_operator\_ui = http://X.X.X.X


##When things go wrong

Output is given on the console if errors occur in terraform.  If a timeout errors occurs during deployment of CMS its typically a service start failure and timeout on alternate services that are waiting for the resource to complete.

The CMS deployment report is downloaded at the end of the apply and  placed in a subfolder under cmsform.  Detail with these files can help determine where the install failed.

Compare the output to the remote-exec section of each instance and determine which command erred.  Resolve any errors and retry.  May have to terraform destroy then terraform apply again for a proper retry.


## Notes
- To debug terraform,  export TF_LOG=DEBUG
- To debug the CMS install - dig though the puppet/installer log files

## TODOs - Next Steps in the automation and work still to do.
- Create hook for installation of the solution ontop of the prepack
    - Work out a way for the install to auto-magically install a tar or rpm? that is the custom solution on top of prepack
    - Some way to run a script if it exists - perhaps looks for a well known script name in the s3 bucket - and if found pull down and execute.
        - The custom solution code could then be in this provided script
- [Optional] Include deployment of the Simulators being created by Anuj for Charter
	- Work in deployment of these onto the same subnet? and setup/hook up resources in the install to use 'em...
- [Optional] Support deployment of the solution into an existing VPC - onto a new subnet
- [Optional] Find a way to automate the detection of the bastion public ip - such that the tool does not need to manually have that value entered as a variable.  I.e. have the terraform script running on the bastion perform the 'dig + short myip.opendns.com @resolver1.opendns.com' and place that output into the aws security group resource.  This would avoid the bug where someone forgets to update the variable - or where the public nat ip of the bastion changes (somehow?)
- [Optional] Speed up the deployment time of the VM's... 
    - There are two stages to the install of each VM in CMS.  Install RPMs and Perform Configuration.
    - Both steps are driven by puppet (puppet\_software.pp and puppet\_site.pp)
    - The installcmsnode.sh batch file performs both of these steps in sequence when invoked on the vm.
    - The CS node must be up and running _prior_ to the other nodes being brought up - the cs node runs services required by the other nodes during the puppet_site.pp run (register with DNS for example)
        - For this reason the cs node is brought up first - and all other nodes (while booted right away) *pause* for signal from the cs ndoe to begin installation.
    - The install can be sped up by relaxing a bit of this - the vm's waiting for the cs node can can perform the 'install RPMs' step _while_ the CS node is running its configuration.  Its the configuration of the VM's that must wait for the configuration of the cs vm.
    - To perform this - we'll need to ... bend... the CMS vm install a bit.
        - cs install stays the same
        - all other vm's do the following in their remote-exec section - replace these lines
        	- # wait for the cluster server to indicate its complete.
        	-     "/root/waitForClusterServer.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/static/staging/ClusterServerReady.txt",
            	- # get the node installer
        	-     "/root/waitAndPullNodeInstall.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/cms-node-config.tgz",
        	-     # do the install
        	-     	"cd /root/staging",
        	-     	# ya - well..
        	-     	"rm -f doCMSHardwareChecks.txt",
        	-     	"./installcmsnode.sh",
        - With these lines
        	- "/root/waitAndPullNodeInstall.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/cms-node-config.tgz",`
        	- "mv /root/puppet_site.pp /root/puppet\_site\_orig.pp",
        	- "touch /root/puppet\_site.pp",
        	- # do the install
        	- "cd /root/staging",
        	- "rm -f doCMSHardareChecks.txt",
        	- "./installcmsnode.sh",
        	- # now wait for the installer
        	- "/root/waitForCLusterServer.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/static/staging/ClusterServerReady.txt",
        	- #restore puppet_site file
        	- "cp -f /root/puppet\_site\_orig.p /root/puppet\_site.pp",
        	- # apply it
        	- "puppet apply /root/puppet\_site.pp -l /root/puppet\_site.log",
        	- #done

## Project Files

Current list of the files in the project - and their usage/purpose.

- cms.tf
    - The main terraform file to install cms.  Uses variables for configuration
- README.md
    - This mardown file
- sample.tfvars
    - A set of sample variables that would be configured to define a new install...  These are values that overdefine what is the default value in the variables.tf file
- sample1nonHA.tpl
    - The cms config.json template that will be used to generate the config.json for the install. Uses terraform variables from the variables.tf and sample.tfvars file to resolve config.json values.
- variables.tf
    - Defines all the variables that make up the cms installer - described inline. some should not be changed...
- vmTools/mountVMdisk.sh
    - Help utility used during vm boot up to partition/format/mount a new volume added to the vm
- vmTools/setHostname.sh
    - Helper utility to set the VM hostname
- vmTools/setupNFSServer.sh
    - Helper utility to install rpms and configure the VM as an NFS Server
- vmTools/waitAndPullNodeInstal.sh
    - Timing helper to wait till the django installation UI has created the node installer tgz file
- vmTools/waitForClusterServer.sh
    - Timing helper to wait till the cs node has completed the puppet configuration pass