# Installs CMS on AWS

provider "aws" {
    region = "${var.aws_region}"
    access_key = "${var.aws_access_key}"
    secret_key = "${var.aws_secret_key}"
    version = "~> 1.13"
}

provider "null" {
    version = "~> 1.0"
}

provider "template" {
    version = "~> 1.0"
}

data "aws_ami" "image_id" {
    most_recent = true
    filter {
        name = "product-code"
        values = [ "${var.aws_ami_product_code}" ]
    }
}

data "aws_availability_zones" "available" {}

#create a file with variables pointing to deployed nodes for use by jenkins jobs
data "template_file" "nodes" {
    template = "${file("nodes.sh.tpl")}"

    vars {
        customerInstanceId = "${var.customerInstanceId}"
        uiVip = "${aws_lb.ui_vip.dns_name}"
        csIps = "${join(" ",aws_instance.cs.*.public_ip)}"
        esIps = "${join(" ",aws_instance.es.*.public_ip)}"
        appIps = "${join(" ",aws_instance.app.*.public_ip)}"
        ptIps = "${join(" ",aws_instance.pt.*.public_ip)}"
        dbHost = "${replace(aws_db_instance.rds.endpoint,"/(.*):.*/","$1")}"
    }
}

resource "null_resource" "nodes" {
    provisioner "local-exec" {
        command = "echo \"${data.template_file.nodes.rendered}\" | sudo tee nodes.sh"
    }
}

# Prepack Configuration file - install_sysInfo.tpl -> install_sysInfo.json
data "template_file" "init2" {
    template = "${file(var.config_install_sysInfo_template)}"

    vars {
        installerIP = "${element(flatten(aws_network_interface.cs_int.*.private_ips), 0)}"
    }
}
