resource "google_compute_address" "app_with_subnet_and_address" {
  count        = var.app_count
  name         = "app-adress-${count.index}"
  region       = var.region
  subnetwork   = google_compute_subnetwork.subnet-us-west1-tvaas-poc.name
  address_type = "INTERNAL"
  address      = "10.0.0.${count.index + 48}"
}

resource "google_compute_instance" "app" {
  count        = var.app_count
  name         = "app-${count.index}"
  machine_type = var.dev_mode ? var.gcp_instance_type_app_dev : var.gcp_instance_type_app

  //
  zone = "${var.region}-${var.zone}"

  boot_disk {
    initialize_params {
      image = "centos-cloud/centos-7"
    }
  }

  metadata = {
    ssh-keys = "test:${file(var.public_key_path)}"
  }

  metadata_startup_script = "sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo"

  network_interface {
    subnetwork = google_compute_subnetwork.subnet-us-west1-tvaas-poc.name
    network_ip = element(
      google_compute_address.app_with_subnet_and_address.*.address,
      count.index,
    )
    //access_config = {}
  }

  depends_on = [google_compute_instance.cs]

  # Need to enable ssh
  # Need to enable ssh
  provisioner "remote-exec" {
    inline = [
      "echo -e '\nClientAliveInterval 60' | sudo tee -a /etc/ssh/sshd_config",
      "sudo systemctl restart sshd",
    ]

    connection {
      host = element(
        google_compute_instance.app.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo mkdir -p /opt/vmTools",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
    ]

    connection {
      host = element(
        google_compute_instance.app.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "file" {
    source      = "vmTools/"
    destination = "/opt/vmTools"

    connection {
      host = element(
        google_compute_instance.app.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo chmod +x /opt/vmTools/*.sh",
      "sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
      "sudo systemctl enable rpcbind.service",
      "sudo systemctl start rpcbind",
      "sudo bash /opt/vmTools/setHostname.sh ${var.cms_hostname_app}${count.index + 1}",
      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
      "sudo yum erase -y python-setuptools",
      "sudo sed -i -e 's/\\(UseDNS.*\\)/\\1\\n/' /etc/ssh/sshd_config",
      "sudo sed -i -e 's/\\(Subsystem sftp.*\\)/#\\1/' /etc/ssh/sshd_config",
      "sudo systemctl stop firewalld",
      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${google_compute_address.cs_with_subnet_and_address[0].address}:8008/cms-node-config.tgz",
      "cd /opt/cms/staging",
      "sudo mkdir -p /opt/db/scripts/install",
      "echo '#!/bin/bash' | sudo tee /opt/db/scripts/install/settings",
      "echo 'DB_ADMIN_PW=${var.db_pass}' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'PGPD=${var.db_pass}' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'DB_PORT=${var.db_port}' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'DB_TYPE=postgres' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'DB_USER=${var.db_user}' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'DB_VERSION=9.5' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'DB_NAME=${var.db_name}' | sudo tee -a /opt/db/scripts/install/settings",
      "echo 'HOST_NAME=dbserver' | sudo tee -a /opt/db/scripts/install/settings",
      "sudo chown nobody:nobody /opt/db/scripts/install/settings",
      "sudo chmod 400 /opt/db/scripts/install/settings",
      "sleep ${270 * count.index}",
      "sudo bash installcmsnode.sh -n ${var.app_count} app${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
    ]

    connection {
      host = element(
        google_compute_instance.app.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
      timeout     = "60m"
    }
  }

  provisioner "remote-exec" {
    inline = [
      "sudo sed -i 's/^pasv_max_port=.*/pasv_max_port=$((pasv_min_port + 9))/g' /etc/puppetlabs/code/modules/vsftpd/files/vsftpdsetup.sh",
      "echo 'pasv_promiscuous=YES' | sudo tee -a /etc/vsftpd/vsftpd.conf",
      "sudo /opt/puppetlabs/bin/puppet apply -e 'include vsftpd'",
    ]

    connection {
      host = element(
        google_compute_instance.app.*.network_interface.0.network_ip,
        count.index,
      )
      type        = "ssh"
      user        = var.ssh_user
      private_key = file(var.private_key_path)
    }
  }
}
