
# CMS Configuration config.json files
resource "template_dir" "config" {
  source_dir      = "${path.module}/config_templates"
  destination_dir = "${path.cwd}/config"

  vars = {
    customerLicenseId = var.cms_license_fingerprint
    privateNetmask    = cidrnetmask(var.gcp_subnet)
    # DNS services are on .2 of the vpc subnet by AWS
    # due to google set it to 8.8.8.8
    vpc_dns        = "8.8.8.8"
    consul_servers = var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\""
    named_master = element(
      flatten(google_compute_address.cs_with_subnet_and_address.*.address),
      0,
    )
    named_slaves = jsonencode(
      slice(
        flatten(google_compute_address.cs_with_subnet_and_address.*.address),
        1,
        length(
          flatten(google_compute_address.cs_with_subnet_and_address.*.address),
        ),
      ),
    )
    cms_nas_server     = google_compute_instance.nfs.network_interface[0].network_ip
    content_nas_server = google_compute_instance.nfs.network_interface[0].network_ip
    mountOptions       = join(",", var.mount_options)
    remount            = var.remount
    privateDomain      = var.cms_dns_domain
    ui_eip             = google_compute_address.cs_vip_external.address
    app_eip            = google_compute_address.cs_vip_external.address
    timezone           = var.timezone
    #dbserver           = "${google_compute_address.pg_with_subnet_and_address.address}"
    dbserver           = google_sql_database_instance.cloudsql_master.private_ip_address
    snmpServer         = var.snmp_server
    privateNetwork     = cidrhost(var.gcp_subnet, 0)
    customerInstanceId = var.customerInstanceId
    installName        = var.install_name
  }
}
