# Disabling CLoud SQL as it doesn't support libxml
resource "google_sql_database_instance" "cloudsql_master" {
  #name             = "db-mast-eb5er"
  database_version = "POSTGRES_9_6"

  depends_on = [google_service_networking_connection.private_vpc_connection]

  #"google_compute_network.cms-network"

  settings {
    tier = "db-custom-8-15360"

    #ip_configuration  {
    #  authorized_networks = [
    #    #name = "all"
    #    #value = "0.0.0.0/0"
    #    "${data.null_data_source.auth_netw_postgres_allowed_1.*.outputs}",
    #    "${data.null_data_source.auth_netw_postgres_allowed_2.*.outputs}",
    #  ]
    #}
    ip_configuration {
      ipv4_enabled    = "false"
      private_network = google_compute_network.cms-network.self_link
    }
  }
}

resource "google_sql_database" "cloudsql_db" {
  name     = var.db_name
  instance = google_sql_database_instance.cloudsql_master.name
}

# create database Users
resource "google_sql_user" "db_sql_user" {
  name     = var.db_user
  instance = google_sql_database_instance.cloudsql_master.name
  host     = "%"
  password = var.db_pass
}

#### Createtig custom machine with PostgressSQL instaled on it
#resource "google_compute_address" "pg_with_subnet_and_address" {
#  name         = "pgdb-adress-${count.index}"
#  region       = "${var.region}"
#  subnetwork   = "${google_compute_subnetwork.subnet-us-west1-tvaas-poc.name}"
#  address_type = "INTERNAL"
#}
#
#resource "google_compute_instance" "postgress" {
#  name         = "${var.name}-postgressdb"
#  machine_type = "${var.dev_mode ? var.gcp_instance_type_rds_dev : var.gcp_instance_type_rds}"
#
#  //
#  zone = "${var.region}-${var.zone}"
#
#  boot_disk {
#    initialize_params {
#      image = "centos-cloud/centos-7"
#    }
#  }
#
#  depends_on = ["google_compute_network_peering.bastion2cms", "google_compute_network_peering.cms2bastion"]
#
#  metadata {
#    ssh-keys = "test:${file("${var.public_key_path}")}"
#  }
#
#  network_interface {
#    subnetwork = "${google_compute_subnetwork.subnet-us-west1-tvaas-poc.name}"
#    network_ip = "${google_compute_address.pg_with_subnet_and_address.address}"
#
#    //access_config = {}
#  }
#
#  provisioner "remote-exec" {
#    inline = [
#      #update existing system packages to lattest versino
#      "sudo yum update -y",
#
#      # add Postgresql repo
#      "sudo rpm -Uvh http://yum.postgresql.org/9.5/redhat/rhel-7-x86_64/pgdg-centos95-9.5-2.noarch.rpm",
#
#      # installling PostgreSQL 9.5
#      "sudo yum -y install postgresql95-server postgresql95",
#
#      #Init DB
#      "sudo /usr/pgsql-9.5/bin/postgresql95-setup initdb",
#
#      # Enable login from 0.0.0.0/0 and pass auth
#      "sudo sed -i 's/#listen_addresses/listen_addresses/g' /var/lib/pgsql/9.5/data/postgresql.conf",
#
#      "sudo sed -i 's/localhost/*/g' /var/lib/pgsql/9.5/data/postgresql.conf",
#      "sudo sed -i 's/max_connections = 100/max_connections = 500/g' /var/lib/pgsql/9.5/data/postgresql.conf",
#      "sudo sed -i 's/ident/md5/g' /var/lib/pgsql/9.5/data/pg_hba.conf",
#      "sudo sed -i -e \"\\$ahost    all     all     0.0.0.0/0       md5\" /var/lib/pgsql/9.5/data/pg_hba.conf",
#
#      #Enable PostgreSQl server on startup
#      "sudo systemctl enable postgresql-9.5",
#
#      # PostgreSQl server
#      "sudo systemctl start postgresql-9.5",
#
#      #"sudo -u postgres bash -c psql -c 'CREATE USER ${var.db_user} WITH PASSWORD '${var.db_pass}';' ",
#      "sudo  -u postgres  psql -c \"ALTER USER ${var.db_user} WITH PASSWORD '${var.db_pass}';\"",
#    ]
#
#    connection {
#      type        = "ssh"
#      user        = "${var.ssh_user}"
#      private_key = "${file(var.private_key_path)}"
#      timeout     = "60m"
#    }
#  }
#}

