provider "google" {
  project = "tvaas-poc"
  region  = var.region
}

provider "google-beta" {
  project = "tvaas-poc"
  region  = var.region
}

provider "null" {
  version = "~> 2.1"
}

provider "template" {
  version = "~> 2.1"
}

data "google_compute_image" "my_image" {
  family  = "centos-7"
  project = "centos-cloud"
}

data "template_file" "init2" {
  template = file(var.config_install_sysInfo_template)

  vars = {
    installerIP = google_compute_address.cs_with_subnet_and_address[0].address
  }
}

resource "null_resource" "cs_cluster_vip_exist" {
  count = var.cs_count

  triggers = {
    cs_vip_loadbalancer = join(
      ",",
      google_compute_forwarding_rule.cs_forwarding_rule_external.*.self_link,
    )
  }

  connection {
    type = "ssh"
    host = element(
      google_compute_instance.cs.*.network_interface.0.network_ip,
      count.index,
    )
    user        = var.ssh_user
    private_key = file(var.private_key_path)
    timeout     = "60m"
  }

  provisioner "remote-exec" {
    inline = [
      "cd /opt/cms/staging",
      "sudo bash installcmsnode.sh -n ${var.cs_count} cs${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
    ]
  }

  depends_on = [google_compute_forwarding_rule.cs_forwarding_rule_external]
}
