# Installs CMS on AWS

provider "aws" {
    region = "${var.aws_region}"
    access_key = "${var.aws_access_key}"
    secret_key = "${var.aws_secret_key}"
    version = "~> 1.13"
}

provider "null" {
    version = "~> 1.0"
}

provider "template" {
    version = "~> 1.0"
}

data "aws_ami" "image_id" {
    most_recent = true
    filter {
        name = "product-code"
        values = [ "${var.aws_ami_product_code}" ]
    }
}

data "aws_availability_zones" "available" {}

