# Network load balancer for internal
resource "aws_lb" "internal_vip" {
    name = "${var.install_name}-int"
    load_balancer_type = "network"
    internal = true
    subnets = ["${aws_subnet.default.*.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}

# Load balancer target group for FTP ports (10 per app)
resource "aws_lb_target_group" "back_end_ftp" {
    count = "${var.app_count * 10}"
    port = "${10000 + count.index % 10 + 100 * (count.index / 10)}"
    protocol = "TCP"
    #vpc_id = "${aws_vpc.default.id}"
    vpc_id = "${ var.existing_vpc_id == 0 ? join("",aws_vpc.default.*.id) : var.existing_vpc_id }"
    target_type = "instance"
}

# Load balancer target group for internal load-balanced ports
resource "aws_lb_target_group" "back_end_internal" {
    count = "${length(var.internal_lb_ports)}"
    port = "${element(var.internal_lb_ports, count.index)}"
    protocol = "TCP"
    #vpc_id = "${aws_vpc.default.id}"
    vpc_id = "${ var.existing_vpc_id == 0 ? join("",aws_vpc.default.*.id) : var.existing_vpc_id }"
    target_type = "ip"
}

# Load balancer target group for FTP ports (10 per app) for internal load balancer
resource "aws_lb_target_group" "back_end_internal_ftp" {
    count = "${var.app_count * 10}"
    port = "${10000 + count.index % 10 + 100 * (count.index / 10)}"
    protocol = "TCP"
    #vpc_id = "${aws_vpc.default.id}"
    vpc_id = "${ var.existing_vpc_id == 0 ? join("",aws_vpc.default.*.id) : var.existing_vpc_id }"
    target_type = "ip"
}

resource "aws_lb_target_group_attachment" "ftp" {
    count = "${var.app_count * 10 * var.cs_count}"
    target_group_arn = "${element(aws_lb_target_group.back_end_ftp.*.arn, count.index / var.cs_count)}"
    target_id = "${element(aws_instance.cs.*.id, count.index)}"
    port = "${10000 + count.index / var.cs_count  % 10 + 100 * (count.index / var.cs_count / 10)}"
}

# Load balancer target group attachments for internal load balancer; each port to each CS node
resource "aws_lb_target_group_attachment" "internal" {
    count = "${length(var.internal_lb_ports) * var.cs_count}"
    target_group_arn = "${element(aws_lb_target_group.back_end_internal.*.arn, count.index / var.cs_count)}"
    target_id = "${element(flatten(aws_network_interface.cs_int.*.private_ips), count.index)}"
    port = "${element(var.internal_lb_ports, count.index / var.cs_count)}"
}

resource "aws_lb_target_group_attachment" "internal_ftp" {
    count = "${var.app_count * 10 * var.cs_count}"
    target_group_arn = "${element(aws_lb_target_group.back_end_internal_ftp.*.arn, count.index / var.cs_count)}"
    target_id = "${element(flatten(aws_network_interface.cs_int.*.private_ips), count.index)}"
    port = "${10000 + count.index / var.cs_count  % 10 + 100 * (count.index / var.cs_count / 10)}"
}

# Load balancer listener for FTP ports for UI load balancer
resource "aws_lb_listener" "front_end_ftp" {
    count = "${var.app_count * 10}"
    load_balancer_arn = "${aws_lb.ui_vip.arn}"
    port = "${10000 + count.index % 10 + 100 * (count.index / 10)}"
    protocol = "TCP"

    default_action {
        target_group_arn = "${element(aws_lb_target_group.back_end_ftp.*.arn, count.index)}"
        type = "forward"
    }
}

# Load balancer listener for internal ports for internal load balancer
resource "aws_lb_listener" "front_end_internal" {
    count = "${length(var.internal_lb_ports)}"
    load_balancer_arn = "${aws_lb.internal_vip.arn}"
    port = "${element(var.internal_lb_ports, count.index)}"
    protocol = "TCP"

    default_action {
        target_group_arn = "${element(aws_lb_target_group.back_end_internal.*.arn, count.index)}"
        type = "forward"
    }
}

# Load balancer listener for FTP ports for internal load balancer
resource "aws_lb_listener" "front_end_internal_ftp" {
    count = "${var.app_count * 10}"
    load_balancer_arn = "${aws_lb.internal_vip.arn}"
    port = "${10000 + count.index % 10 + 100 * (count.index / 10)}"
    protocol = "TCP"

    default_action {
        target_group_arn = "${element(aws_lb_target_group.back_end_internal_ftp.*.arn, count.index)}"
        type = "forward"
    }
}

# Network load balancer for UI; internet-facing
resource "aws_lb" "ui_vip" {
    name = "${var.install_name}"
    load_balancer_type = "network"
    internal = false
    subnets = ["${aws_subnet.default.*.id}"]
    depends_on = ["aws_network_interface.cs_int"]
}

# Load balancer target group for UI ports
resource "aws_lb_target_group" "back_end_ui" {
    count = "${length(var.ui_ports)}"
    port = "${element(var.ui_ports, count.index)}"
    protocol = "TCP"
    #vpc_id = "${aws_vpc.default.id}"
    vpc_id = "${ var.existing_vpc_id == 0 ? join("",aws_vpc.default.*.id) : var.existing_vpc_id }"
    target_type = "instance"
}

# Load balancer target group for UI ports for internal load balancer
resource "aws_lb_target_group" "back_end_internal_ui" {
    count = "${length(var.ui_ports)}"
    port = "${element(var.ui_ports, count.index)}"
    protocol = "TCP"
    #vpc_id = "${aws_vpc.default.id}"
    vpc_id = "${ var.existing_vpc_id == 0 ? join("",aws_vpc.default.*.id) : var.existing_vpc_id }"
    target_type = "ip"
}

# Load balancer target group attachments for UI load balancer; each port to each CS node
resource "aws_lb_target_group_attachment" "ui" {
    count = "${length(var.ui_ports) * var.cs_count}"
    target_group_arn = "${element(aws_lb_target_group.back_end_ui.*.arn, count.index / var.cs_count)}"
    target_id = "${element(aws_instance.cs.*.id, count.index)}"
    port = "${element(var.ui_ports, count.index / var.cs_count)}"
}

resource "aws_lb_target_group_attachment" "internal_ui" {
    count = "${length(var.ui_ports) * var.cs_count}"
    target_group_arn = "${element(aws_lb_target_group.back_end_internal_ui.*.arn, count.index / var.cs_count)}"
    target_id = "${element(flatten(aws_network_interface.cs_int.*.private_ips), count.index)}"
    port = "${element(var.ui_ports, count.index / var.cs_count)}"
}

# Load balancer listener for UI ports for UI load balancer
resource "aws_lb_listener" "front_end_ui" {
    count = "${length(var.ui_ports)}"
    load_balancer_arn = "${aws_lb.ui_vip.arn}"
    port = "${element(var.ui_ports, count.index)}"
    protocol = "TCP"

    default_action {
        target_group_arn = "${element(aws_lb_target_group.back_end_ui.*.arn, count.index)}"
        type = "forward"
    }
}

# Load balancer listener for UI ports for internal load balancer
resource "aws_lb_listener" "front_end_internal_ui" {
    count = "${length(var.ui_ports)}"
    load_balancer_arn = "${aws_lb.internal_vip.arn}"
    port = "${element(var.ui_ports, count.index)}"
    protocol = "TCP"

    default_action {
        target_group_arn = "${element(aws_lb_target_group.back_end_internal_ui.*.arn, count.index)}"
        type = "forward"
    }
}
