resource null_resource post_install {
  count = var.es_count > 0 ? 1 : 0
  depends_on = [null_resource.es_checklogs, null_resource.pt_checklogs, null_resource.app_checklogs, null_resource.ct_checklogs]

  connection {
    host = google_compute_instance.cs[0].network_interface.0.network_ip
    type = "ssh"
    user = var.ssh_user
    private_key = file(var.private_key_path)
    timeout     = "20m"
  }
  
  provisioner remote-exec {
    inline = [
      "sleep 30",
      #"sh /opt/cms/installer/post_install.sh ${google_compute_address.cs_vip_external.address}",
      #Configuring Elasticsearch for number of Masters and Replicas
      "echo \"Configuring number of Master nodes, Replicas for Elasticsearch on CS and ES.\"",
      "bash /opt/cms/installer/scripts/elasticsearch_config.sh ${google_compute_address.cs_vip_external.address}",
      "if [ \"$?\" != \"0\" ]; then echo \"Configuring Elasticsearch for number Master and Replica count failed.\";exit 1; fi",
    ]
  }
}
