#!/bin/bash
# mountVMDisk.sh - utlitiy to partition available disks and mount into file system.
#  mountVMDisk.sh [<mount folder> <starting%  ending%>]
#  the % parameters must be one - quote the space between the two percents.
#	the pair of mount folder and percents can be repleated.
#	the percents must not over lap and should cover the whole of the disk.
#
#	i.e.   mountVMDisk /var/log "0% 15%"  /opt "26% 100%"
#
# Chris Bentz - May 2017
echo "Provision, partition and mount new disk"
# make sure we have parted utility
yum install parted -y -q
if [ $? -ne 0 ]; then
	echo "Parted failed to yum install. Are you root? Aborting"
	exit 1
fi

# get disk device available.
device=`parted -l 2>&1 | grep Error | head -n 1 | awk '{print substr($2,0,length($2)-1)}'`
if [ "$device" == "" ]; then
	echo "No available device found to mount."
	exit 1
fi

# label the device
parted $device mklabel gpt

deviceName=`while IFS='/' read -ra path; do  echo ${path[2]}; done <<< "$device"`

# create the partition.

partition=0
while [ $# -gt 1 ];
# $1 is the folder to mount to
# $2 is the start% end% value for parted.  i.e. how much of the disk to use for this mount point.
do
	partition=$((partition+1))

	echo "\1 is $1"
	echo "\2 is $2"
	echo "partition is $partition"

	# create the partition
	parted -a opt $device mkpart primary ext4 $2 
	# poke the kernel
	partx -v -a $device
	mkfs.ext4 -L ${deviceName}Volume$partition ${device}$partition
	echo "LABEL=${deviceName}Volume$partition $1 ext4 defaults 0 0" >>/etc/fstab
	
	# now - do we simply mount or migrate existing data.
	if [ -d "$1" ]; then
		# folder exists.  Migrate data?
		if [ "$(ls -A $1)" ]; then
			# migrate.
			/bin/mv "$1" "$1".orig
			mkdir -p "$1"
			mount "$1"
			/bin/cp -rfp "$1.orig/"* "$1" 
			if [ $? -ne 0 ]; then
				# try without the p
				/bin/cp -rf "$1.orig/"* "$1"
				if [ $? -ne 0 ]; then
					echo "Failed to copy existing content."
					exit 1
				fi
			fi
			# remove old
			/bin/rm -rf "$1".orig
		else
			# just mount onto the existing empty directory
			mount "$1"
		fi
	else
		mkdir -p "$1"
		mount "$1"
	fi
	
	# on to the next one.
	shift
	shift
	
done
