#!/bin/bash
# waitAndPullNodeInstall.sh  - utility to pause execution till the Installer Node has created the cms-node-config.json file it has been downloaded.
# waitAndPullNodeInstall.sh  <url-to-installer-cms-node-config.tgz file>
#
# Chris Bentz - May 2017

if [ -z "$1" ]; then
    echo "Usage: $0 <url-to-installer-cms-node-config.tgz-file>"
    exit 1
fi

if [ ! -d /var/log/cms/installer ]; then
    mkdir -p /var/log/cms/installer
fi

if [ ! -d /opt/cms ]; then
    mkdir -p /opt/cms
fi
cd /opt/cms
time=0
timeout=3600
response=$(curl --write-out %{http_code} --silent --HEAD --output /dev/null $1)
while [ $response -ne 200 ]
do
    if [ $time -ge $timeout ]; then
        echo "Installer node not ready after $time seconds."
        exit 1
    fi
    time=$((time+30))
    echo "Waiting for Installer on $1..."
    sleep 30
    response=$(curl --write-out %{http_code} --silent --HEAD --output /dev/null $1)
done
echo Installer Ready!
# get it - but make sure we get it...
curl -O $1
while [ ! -f cms-node-config.tgz ]
do
    if [ $time -ge $timeout ]; then
        echo "Couldn't get required cms-nodes.tar.gz from Installer node."
        exit 1
    fi
    sleep 5
    time=$((time+5))
    curl -O $1
done
#expand it
tar xzvf cms-node-config.tgz
