# CMS terraform AWS template 

##

```
git clone  http://gitlab.tandbergtv.lan/cms-system-integration-installer/cmsform.git
```

## Overview
This script provisions a set of resources in AWS and installs the CMS.  




## Deploy a CMS Install
Git clone the source from git onto a new folder. 

- Download the following packages from the CMS repo and place them in the packages subdirectory
    - CMS Software Packages RPM (cms-swo-repo-7.0.000.354-0.el7.noarch.rpm).
    - CMS Installer RPM (cmsinstaller-7.0.000.87-0.noarch.rpm).
    
- Copy the CMS license file license.xml to the AWS installer working directory. 

- Update the sample1.tfvars with values for the following

    - install_name - A string used to generate unique names for this CMS deployment.
    This name needs to be unique for each deployment in an AWS account, which
    contain only alphanumeric characters or hyphens.
    - external_whitelist - A list of networks in CIDR format that can access CMS in
    AWS. For most corporate networks, this is the IP used by the firewall for outbound
    internet traffic. Do not use 0.0.0.0/0, since this opens the deployment to the public
    and is a security risk.
    - admin_whitelist - A list of networks in CIDR format which has full access to
    CMS in AWS. Do not use 0.0.0.0/0, since this opens the deployment to the public
    and is a security risk . This is only used for testing purposes.
    - bastion_public_cidr - A list of networks in CIDR format which is able to SSH to
    CMS nodes in AWS. This list contains the installer node. If the installer node is on the
    corporate network, this value is the same as external_whitelist.
    - cms_license_fingerprint - The fingerprint used when the CMS license is
    requested.
    - private_key_path - The SSH private key used to access deployed instances.
    - public_key_path - The SSH public key added to the deployed instances.
    - aws_region - The AWS region in which the CMS is deployed.
    - aws_access_key - An access key associated with the AWS account.
    - aws_secret_key - A secret key that corresponds with the AWS access key.
    - timezone – Timezone to configure on each deployed instance.
    - cs_count - Number of CS nodes to create.
    - app_count - Number of APP nodes to create.
    - es_count - Number of ES nodes to create.
    - pt_count - Number of PT nodes to create.
    - az_count - Number of Availability Zones to spread the cluster on. This should
    match the number of CS nodes.
    - rds_multi_az - Boolean value for enabling multiple availability zones for the
    database for high availability and durability
    

When the preparation is complete, the AWS installer working directory looks like the following.

```
$ tree cmsform
cmsform/
├── cms.tf
├── config_templates
│ ├── cms.json
│ ├── consul.json
│ ├── mounts.json
│ ├── named.json
│ ├── snmp.json
├── license.xml
├── nodes.sh.tpl
├── packages
│ ├── cmsinstaller-7.0.000.xxx-0.noarch.rpm
│ └── cms-swo-repo-7.0.000.xxx-0.noarch.rpm
├── prepackTools
│ └── install_sysInfo_1NonHA.tpl
├── sample.tfvars
├── variables.tf
└── vmTools
 ├── mountVMdisk.sh
 ├── precreate_ttv_db.sh
 ├── setHostname.sh
 ├── setupNFSServer.sh
 ├── waitAndPullNodeInstall.sh
 └── waitForClusterServer.sh
```


Execute the terraform script to deploy the software

`$ terraform apply -var-file=sample1.tfvars`

To destroy the install (and release AWS resources)

`$ terraform destroy -force`

##When things go right

The Terraform install will complete in about 1/2 an hour with the URLs to various CMS resources created in AWS.   Specifically try the operator ui - default login passwords apply.


Outputs:

cms\_central\_logger ui = http://X.X.X.X:9292

cms\_consul\_ui = http://X.X.X.X:8500

cms\_haproxy\_ui = http://X.X.X.X:9090

cms\_operator\_ui = http://X.X.X.X


##When things go wrong

Output is given on the console if errors occur in terraform.  If a timeout errors occurs during deployment of CMS its typically a service start failure and timeout on alternate services that are waiting for the resource to complete.

Compare the output to the remote-exec section of each instance and determine which command erred.  Resolve any errors and retry.  May have to terraform destroy then terraform apply again for a proper retry.


## Notes
- To debug terraform,  export TF_LOG=DEBUG
- To debug the CMS install - dig though the puppet/installer log files

## TODOs - Next Steps in the automation and work still to do.
- Create hook for installation of the solution ontop of the prepack
    - Work out a way for the install to auto-magically install a tar or rpm? that is the custom solution on top of prepack
    - Some way to run a script if it exists - perhaps looks for a well known script name in the s3 bucket - and if found pull down and execute.
        - The custom solution code could then be in this provided script
- [Optional] Include deployment of the Simulators being created by Anuj for Charter
	- Work in deployment of these onto the same subnet? and setup/hook up resources in the install to use 'em...
- [Optional] Support deployment of the solution into an existing VPC - onto a new subnet
- [Optional] Find a way to automate the detection of the bastion public ip - such that the tool does not need to manually have that value entered as a variable.  I.e. have the terraform script running on the bastion perform the 'dig + short myip.opendns.com @resolver1.opendns.com' and place that output into the aws security group resource.  This would avoid the bug where someone forgets to update the variable - or where the public nat ip of the bastion changes (somehow?)
- [Optional] Speed up the deployment time of the VM's... 
    - There are two stages to the install of each VM in CMS.  Install RPMs and Perform Configuration.
    - Both steps are driven by puppet (puppet\_software.pp and puppet\_site.pp)
    - The installcmsnode.sh batch file performs both of these steps in sequence when invoked on the vm.
    - The CS node must be up and running _prior_ to the other nodes being brought up - the cs node runs services required by the other nodes during the puppet_site.pp run (register with DNS for example)
        - For this reason the cs node is brought up first - and all other nodes (while booted right away) *pause* for signal from the cs ndoe to begin installation.
    - The install can be sped up by relaxing a bit of this - the vm's waiting for the cs node can can perform the 'install RPMs' step _while_ the CS node is running its configuration.  Its the configuration of the VM's that must wait for the configuration of the cs vm.
    - To perform this - we'll need to ... bend... the CMS vm install a bit.
        - cs install stays the same
        - all other vm's do the following in their remote-exec section - replace these lines
        	- # wait for the cluster server to indicate its complete.
        	-     "/root/waitForClusterServer.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/static/staging/ClusterServerReady.txt",
            	- # get the node installer
        	-     "/root/waitAndPullNodeInstall.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/cms-node-config.tgz",
        	-     # do the install
        	-     	"cd /root/staging",
        	-     	# ya - well..
        	-     	"rm -f doCMSHardwareChecks.txt",
        	-     	"./installcmsnode.sh",
        - With these lines
        	- "/root/waitAndPullNodeInstall.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/cms-node-config.tgz",`
        	- "mv /root/puppet_site.pp /root/puppet\_site\_orig.pp",
        	- "touch /root/puppet\_site.pp",
        	- # do the install
        	- "cd /root/staging",
        	- "rm -f doCMSHardareChecks.txt",
        	- "./installcmsnode.sh",
        	- # now wait for the installer
        	- "/root/waitForCLusterServer.sh http://${cidrhost(var.aws\_subnet\_cidr,10)}:8888/static/staging/ClusterServerReady.txt",
        	- #restore puppet_site file
        	- "cp -f /root/puppet\_site\_orig.p /root/puppet\_site.pp",
        	- # apply it
        	- "puppet apply /root/puppet\_site.pp -l /root/puppet\_site.log",
        	- #done

## Project Files

Current list of the files in the project - and their usage/purpose.

- cms.tf
    - The main terraform file to install cms.  Uses variables for configuration
- README.md
    - This mardown file
- sample.tfvars
    - A set of sample variables that would be configured to define a new install...  These are values that overdefine what is the default value in the variables.tf file
- config_templates 
    - Contains as set of json template files that will be used to generate the json config files for the CMS software install. Uses terraform variables to populate values in the config files
- variables.tf
    - Defines all the variables that make up the cms installer - described inline. some should not be changed...
- vmTools/mountVMdisk.sh
    - Help utility used during vm boot up to partition/format/mount a new volume added to the vm
- vmTools/precreate_ttv_db.sh
    - Used to set up ttv database 
- vmTools/setHostname.sh
    - Helper utility to set the VM hostname
- vmTools/waitAndPullNodeInstal.sh
    - Timing helper to wait till the django installation UI has created the node installer tgz file
- vmTools/waitForClusterServer.sh
    - Timing helper to wait till the cs node has completed the puppet configuration pass