resource "aws_instance" "es" {
  tags = {
    Name = "es${count.index + 1}-${var.install_name}"
  }
  count = var.es_count

  lifecycle {
    ignore_changes = [ami]
  }

  #depends_on = ["aws_db_instance.rds","aws_instance.cs"]

  ami           = data.aws_ami.image_id.id
  instance_type = var.dev_mode ? var.aws_instance_type_es_dev : var.aws_instance_type_es
  key_name      = aws_key_pair.keypair.id
  subnet_id     = element(aws_subnet.default.*.id, count.index + 2)

  root_block_device {
    delete_on_termination = true
    volume_type           = var.root_volume_type
  }

  ebs_block_device {
    delete_on_termination = true
    device_name           = "/dev/sdc"
    volume_size           = var.aws_instance_block_size_es
    volume_type           = var.block_volume_type
  }

  vpc_security_group_ids = [aws_security_group.private.id, aws_security_group.admin.id]
}

resource "null_resource" "es_installcms" {
  #The terraform version 0.12 will support null_resource.cs_installcms[0] parameter,So it need change this parameter later.
  depends_on = [
    aws_instance.es,
    null_resource.prepare_rpms,
    null_resource.cs_installcms,
  ]
  count = var.es_count

  connection {
    host        = element(aws_instance.es.*.public_ip, count.index)
    type        = "ssh"
    user        = var.ssh_user
    private_key = file(var.private_key_path)
    timeout     = "60m"
  }

  provisioner "remote-exec" {
    inline = [
      "sudo mkdir -p /opt/vmTools",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/vmTools",
    ]
  }

  provisioner "file" {
    source      = "../vmTools/"
    destination = "/opt/vmTools"
  }

  provisioner "remote-exec" {
    inline = [
      "sudo chmod +x /opt/vmTools/*.sh",
      "sudo bash /opt/vmTools/mountVMdisk.sh /var/log \"0% 25%\" /opt \"26% 100%\"",
      "sudo bash /opt/vmTools/setHostname.sh ${var.cms_hostname_es}${count.index + 1}",
      "echo 'PEERDNS=no' | sudo tee -a /etc/sysconfig/network-scripts/ifcfg-eth0",
      "sudo yum erase -y python-setuptools",
      "sudo systemctl stop firewalld",
      "sudo systemctl stop iptables",
      "sudo bash /opt/vmTools/waitAndPullNodeInstall.sh http://${element(flatten(aws_network_interface.cs_int.*.private_ips), 0)}:8008/cms-node-config.tgz",
      "sudo chown ${var.ssh_user}:${var.ssh_user} /opt/cms",
      "cd /opt/cms/staging",
      "sudo bash installcmsnode.sh -n ${var.es_count} es${count.index + 1} |& sudo tee -a /var/log/cms/installer/installcmsnode.log; test $${PIPESTATUS[0]} -eq 0",
    ]
  }
}

output "es_nodes" {
  value = aws_instance.es.*.public_ip
}

