#!/bin/bash

#UpdateConfigJSONs.sh --> Used to update configuration jsons (named, consul) for multiple CS nodes
#UpdateConfigJSONs.sh <CS node count> <APP node count> <ES node count> <AWS subnet network ip>

if [ -z "$1" ] || [ -z "$2" ] || [ -z "$3" ] || [ -z "$4" ] ; then
	echo "Usage: $0 <Number of CS nodes> <Number of APP nodes> <Number of ES nodes> <AWS subnet network ip>"
	exit 1
fi

if [ $1 == 1 ]; then
    echo "There is only one CS node. No changes applied to configuration jsons"
    exit 0
fi

if ! rpm -q jq; then
    sudo yum install jq -y
fi
IP=$(awk -F'.' '{print $1"."$2"."$3"."}'<<<$4)

#Updating named slaves if number of CS nodes are more than 1
if [ $1 > 1 ] && [ -f /opt/cms/installer/staging/config/named.json ]; then
    CS_COUNT="$1"
    named_slaves=""
    while :; do
        if [ "$CS_COUNT" == "1" ]; then
            break
        fi
        OCTET=$CS_COUNT"0"
        named_slaves="$named_slaves\"$IP$OCTET\" "
        CS_COUNT=$((CS_COUNT-1))
    done
    named_slaves=$(echo $named_slaves | tr ' ' ,)
    jq -r ".named.slaves |= .+ [${named_slaves}]" /opt/cms/installer/staging/config/named.json > /tmp/named.json
    echo "Updating named.json"
    /bin/cp /tmp/named.json /opt/cms/installer/staging/config/named.json
fi

#Updating consul servers if at least 3 CS nodes are present
if [ $1 -ge 3 ] && [ -f /opt/cms/installer/staging/config/consul.json ]; then
    jq -r '.consul.servers |= .+ ["cs2", "cs3"]' /opt/cms/installer/staging/config/consul.json > /tmp/consul.json
    echo "Updating consul.json"
    /bin/cp /tmp/consul.json /opt/cms/installer/staging/config/consul.json
fi
