# Build number: 8.0.000.25

# CMS Configuration config.json files
data "aws_vpc" "existing_subnet" {
    id = "${var.existing_vpc_id == 0 ?  join("", aws_vpc.default.*.id) : var.existing_vpc_id}"
}

resource "template_dir" "config" {
    source_dir = "../config_templates",
    destination_dir = "${path.cwd}/config"

    vars {
        customerLicenseId = "${var.cms_license_fingerprint}"
        privateNetmask = "${cidrnetmask(var.aws_subnet_cidr)}"
        # DNS services are on .2 of the vpc subnet by AWS
        vpc_dns = "${ cidrhost(data.aws_vpc.existing_subnet.cidr_block, 2 ) }"
        #vpc_dns = "${cidrhost(var.aws_vpc_cidr, 2)}"
        consul_servers = "${var.cs_count >= 3 ? "\"cs1\",\"cs2\",\"cs3\"" : "\"cs1\"" }"
        named_master = "${element(flatten(aws_network_interface.cs_int.*.private_ips), 0)}"
        named_slaves = "${jsonencode(slice(flatten(aws_network_interface.cs_int.*.private_ips), 1, length(flatten(aws_network_interface.cs_int.*.private_ips))))}"
        cms_nas_type = "${var.cms_nas_type}"
        ct_nas_type  = "${var.ct_nas_type}"
        cms_nas_server = "${aws_efs_file_system.cms.dns_name}"
        content_nas_server = "${aws_efs_file_system.content.dns_name}"
        cms_nas_share     = "${var.cms_nas_share}"
        content_nas_share = "${var.content_nas_share}"
        ct_cms_nas_server = "${ join("", aws_efs_file_system.ct.*.dns_name)}"
        ct_content_nas_server = "${join("", aws_efs_file_system.ct_content.*.dns_name)}"
        ct_cms_nas_share     = "${var.ct_cms_nas_share}"
        ct_content_nas_share = "${var.ct_content_nas_share}"
        mountOptions = "${join(",", var.mount_options)}"
        remount = "${var.remount}"
        privateDomain = "${var.cms_dns_domain}"
        ui_eip = "${var.ct_count > 0 ? aws_lb.internal_vip.dns_name : aws_lb.ui_vip.dns_name}"
        app_eip = "${aws_lb.internal_vip.dns_name}"
        timezone = "${var.timezone}"
        dbserver = "${aws_db_instance.rds.address}"
        snmpServer = "${var.snmp_server}"
        privateNetwork = "${cidrhost(var.aws_subnet_cidr,0)}"
        customerInstanceId = "${var.customerInstanceId}"
        installName = "${var.install_name}"
        cloudextct = "${var.cloud_ext_ct ? true : false }"
        hasct = "${((var.ct_count > 0 ?  1 : 0 ) + (var.cloud_ext_ct ? 1 : 0 )) >= 1 ? true : false }"
    }
}

output "cms_operator_ui" {
    value = "https://${aws_lb.ui_vip.dns_name}:8443"
}

output "cms_central_logger_ui" {
    value = "http://${aws_lb.ui_vip.dns_name}:9292"
}

output "cms_consul_ui" {
    value = "http://${aws_lb.ui_vip.dns_name}:8501"
}
